package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.RegistrationResponseCommandsInner;
import com.okta.sdk.resource.model.RegistrationResponseError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RegistrationResponse
 */
@JsonPropertyOrder({ RegistrationResponse.JSON_PROPERTY_COMMANDS, RegistrationResponse.JSON_PROPERTY_ERROR })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class RegistrationResponse implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_COMMANDS = "commands";
    private List<RegistrationResponseCommandsInner> commands = null;

    public static final String JSON_PROPERTY_ERROR = "Error";
    private RegistrationResponseError error;

    public RegistrationResponse() {
    }

    public RegistrationResponse commands(List<RegistrationResponseCommandsInner> commands) {

        this.commands = commands;
        return this;
    }

    public RegistrationResponse addcommandsItem(RegistrationResponseCommandsInner commandsItem) {
        if (this.commands == null) {
            this.commands = new ArrayList<>();
        }
        this.commands.add(commandsItem);
        return this;
    }

    /**
     * The &#x60;commands&#x60; object lets you invoke commands to modify or add values to the attributes in the Okta
     * user profile that are created for this user. The object also lets you control whether or not the registration
     * attempt is allowed to proceed. This object is an array, allowing you to send multiple commands in your response.
     * Each array element requires a &#x60;type&#x60; property and a &#x60;value&#x60; property. The &#x60;type&#x60;
     * property is where you specify which of the supported commands you wish to execute, and &#x60;value&#x60; is where
     * you supply parameters for that command. The registration inline hook supports these three commands: *
     * &#x60;com.okta.user.profile.update&#x60;: Change attribute values in the user&#39;s Okta user profile. For SSR
     * only. Invalid if used with a Progressive Profile response. * &#x60;com.okta.action.update&#x60;: Allow or deny
     * the user&#39;s registration. * &#x60;com.okta.user.progressive.profile.update&#x60;: Change attribute values in
     * the user&#39;s Okta Progressive Profile.
     *
     * @return commands
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `commands` object lets you invoke commands to modify or add values to the attributes in the Okta user profile that are created for this user. The object also lets you control whether or not the registration attempt is allowed to proceed.  This object is an array, allowing you to send multiple commands in your response. Each array element requires a `type` property and a `value` property. The `type` property is where you specify which of the supported commands you wish to execute, and `value` is where you supply parameters for that command.  The registration inline hook supports these three commands: * `com.okta.user.profile.update`: Change attribute values in the user's Okta user profile. For SSR only. Invalid if used with a Progressive Profile response. * `com.okta.action.update`: Allow or deny the user's registration. * `com.okta.user.progressive.profile.update`: Change attribute values in the user's Okta Progressive Profile.")
    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<RegistrationResponseCommandsInner> getCommands() {
        return commands;
    }

    @JsonProperty(JSON_PROPERTY_COMMANDS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setCommands(List<RegistrationResponseCommandsInner> commands) {
        this.commands = commands;
    }

    public RegistrationResponse error(RegistrationResponseError error) {

        this.error = error;
        return this;
    }

    /**
     * Get error
     *
     * @return error
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public RegistrationResponseError getError() {
        return error;
    }

    @JsonProperty(JSON_PROPERTY_ERROR)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setError(RegistrationResponseError error) {
        this.error = error;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RegistrationResponse registrationResponse = (RegistrationResponse) o;
        return Objects.equals(this.commands, registrationResponse.commands)
                && Objects.equals(this.error, registrationResponse.error);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(commands, error);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationResponse {\n");
        sb.append("    commands: ").append(toIndentedString(commands)).append("\n");
        sb.append("    error: ").append(toIndentedString(error)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
