package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * ResourceSelectorCreateRequestSchema
 */
@JsonPropertyOrder({ ResourceSelectorCreateRequestSchema.JSON_PROPERTY_DESCRIPTION,
        ResourceSelectorCreateRequestSchema.JSON_PROPERTY_FILTER,
        ResourceSelectorCreateRequestSchema.JSON_PROPERTY_NAME,
        ResourceSelectorCreateRequestSchema.JSON_PROPERTY_SCHEMA })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ResourceSelectorCreateRequestSchema implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;

    public static final String JSON_PROPERTY_FILTER = "filter";
    private String filter;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_SCHEMA = "schema";
    private String schema;

    public ResourceSelectorCreateRequestSchema() {
    }

    public ResourceSelectorCreateRequestSchema description(String description) {

        this.description = description;
        return this;
    }

    /**
     * Description of the Resource Selector
     *
     * @return description
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Description of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDescription() {
        return description;
    }

    @JsonProperty(JSON_PROPERTY_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceSelectorCreateRequestSchema filter(String filter) {

        this.filter = filter;
        return this;
    }

    /**
     * SCIM filter of the Resource Selector
     *
     * @return filter
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "SCIM filter of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFilter() {
        return filter;
    }

    @JsonProperty(JSON_PROPERTY_FILTER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public ResourceSelectorCreateRequestSchema name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Name of the Resource Selector
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Name of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ResourceSelectorCreateRequestSchema schema(String schema) {

        this.schema = schema;
        return this;
    }

    /**
     * Schema of the Resource Selector
     *
     * @return schema
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Schema of the Resource Selector")
    @JsonProperty(JSON_PROPERTY_SCHEMA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSchema() {
        return schema;
    }

    @JsonProperty(JSON_PROPERTY_SCHEMA)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSelectorCreateRequestSchema resourceSelectorCreateRequestSchema = (ResourceSelectorCreateRequestSchema) o;
        return Objects.equals(this.description, resourceSelectorCreateRequestSchema.description)
                && Objects.equals(this.filter, resourceSelectorCreateRequestSchema.filter)
                && Objects.equals(this.name, resourceSelectorCreateRequestSchema.name)
                && Objects.equals(this.schema, resourceSelectorCreateRequestSchema.schema);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(description, filter, name, schema);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSelectorCreateRequestSchema {\n");
        sb.append("    description: ").append(toIndentedString(description)).append("\n");
        sb.append("    filter: ").append(toIndentedString(filter)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    schema: ").append(toIndentedString(schema)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
