package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ResourceSetResourceLinksGroups;
import com.okta.sdk.resource.model.ResourceSetResourceLinksResource;
import com.okta.sdk.resource.model.ResourceSetResourceLinksSelf;
import com.okta.sdk.resource.model.ResourceSetResourceLinksUsers;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Related discoverable resources
 */
@ApiModel(description = "Related discoverable resources")
@JsonPropertyOrder({ ResourceSetResourceLinks.JSON_PROPERTY_SELF, ResourceSetResourceLinks.JSON_PROPERTY_RESOURCE,
        ResourceSetResourceLinks.JSON_PROPERTY_GROUPS, ResourceSetResourceLinks.JSON_PROPERTY_USERS })
@JsonTypeName("ResourceSetResource__links")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class ResourceSetResourceLinks implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_SELF = "self";
    private ResourceSetResourceLinksSelf self;

    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private ResourceSetResourceLinksResource resource;

    public static final String JSON_PROPERTY_GROUPS = "groups";
    private ResourceSetResourceLinksGroups groups;

    public static final String JSON_PROPERTY_USERS = "users";
    private ResourceSetResourceLinksUsers users;

    public ResourceSetResourceLinks() {
    }

    public ResourceSetResourceLinks self(ResourceSetResourceLinksSelf self) {

        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSetResourceLinksSelf getSelf() {
        return self;
    }

    @JsonProperty(JSON_PROPERTY_SELF)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSelf(ResourceSetResourceLinksSelf self) {
        this.self = self;
    }

    public ResourceSetResourceLinks resource(ResourceSetResourceLinksResource resource) {

        this.resource = resource;
        return this;
    }

    /**
     * Get resource
     *
     * @return resource
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_RESOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSetResourceLinksResource getResource() {
        return resource;
    }

    @JsonProperty(JSON_PROPERTY_RESOURCE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setResource(ResourceSetResourceLinksResource resource) {
        this.resource = resource;
    }

    public ResourceSetResourceLinks groups(ResourceSetResourceLinksGroups groups) {

        this.groups = groups;
        return this;
    }

    /**
     * Get groups
     *
     * @return groups
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSetResourceLinksGroups getGroups() {
        return groups;
    }

    @JsonProperty(JSON_PROPERTY_GROUPS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setGroups(ResourceSetResourceLinksGroups groups) {
        this.groups = groups;
    }

    public ResourceSetResourceLinks users(ResourceSetResourceLinksUsers users) {

        this.users = users;
        return this;
    }

    /**
     * Get users
     *
     * @return users
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public ResourceSetResourceLinksUsers getUsers() {
        return users;
    }

    @JsonProperty(JSON_PROPERTY_USERS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUsers(ResourceSetResourceLinksUsers users) {
        this.users = users;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ResourceSetResourceLinks resourceSetResourceLinks = (ResourceSetResourceLinks) o;
        return Objects.equals(this.self, resourceSetResourceLinks.self)
                && Objects.equals(this.resource, resourceSetResourceLinks.resource)
                && Objects.equals(this.groups, resourceSetResourceLinks.groups)
                && Objects.equals(this.users, resourceSetResourceLinks.users);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(self, resource, groups, users);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceSetResourceLinks {\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    resource: ").append(toIndentedString(resource)).append("\n");
        sb.append("    groups: ").append(toIndentedString(groups)).append("\n");
        sb.append("    users: ").append(toIndentedString(users)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
