package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.LinksSelfAndRoles;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * RoleAssignedUser
 */
@JsonPropertyOrder({ RoleAssignedUser.JSON_PROPERTY_ID, RoleAssignedUser.JSON_PROPERTY_ORN,
        RoleAssignedUser.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class RoleAssignedUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelfAndRoles links;

    public RoleAssignedUser() {
    }

    /*
     * @JsonCreator public RoleAssignedUser(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_ORN) String orn ) { this(); this.id = id; this.orn = orn; }
     */

    /**
     * The ID of the User
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The ID of the User")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * ORN representing the assignee
     *
     * @return orn
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "ORN representing the assignee")
    @JsonProperty(JSON_PROPERTY_ORN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getOrn() {
        return orn;
    }

    public RoleAssignedUser links(LinksSelfAndRoles links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LinksSelfAndRoles getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelfAndRoles links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RoleAssignedUser roleAssignedUser = (RoleAssignedUser) o;
        return Objects.equals(this.id, roleAssignedUser.id) && Objects.equals(this.orn, roleAssignedUser.orn)
                && Objects.equals(this.links, roleAssignedUser.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, orn, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RoleAssignedUser {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    orn: ").append(toIndentedString(orn)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
