package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAML 1.1 sign-on mode attributes
 */
@ApiModel(description = "SAML 1.1 sign-on mode attributes")
@JsonPropertyOrder({ Saml11ApplicationSettingsSignOn.JSON_PROPERTY_AUDIENCE_OVERRIDE,
        Saml11ApplicationSettingsSignOn.JSON_PROPERTY_DEFAULT_RELAY_STATE,
        Saml11ApplicationSettingsSignOn.JSON_PROPERTY_RECIPIENT_OVERRIDE,
        Saml11ApplicationSettingsSignOn.JSON_PROPERTY_SSO_ACS_URL_OVERRIDE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class Saml11ApplicationSettingsSignOn implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private String audienceOverride;

    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private String defaultRelayState;

    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private String recipientOverride;

    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private String ssoAcsUrlOverride;

    public Saml11ApplicationSettingsSignOn() {
    }

    public Saml11ApplicationSettingsSignOn audienceOverride(String audienceOverride) {

        this.audienceOverride = audienceOverride;
        return this;
    }

    /**
     * The intended audience of the SAML assertion. This is usually the Entity ID of your application.
     *
     * @return audienceOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The intended audience of the SAML assertion. This is usually the Entity ID of your application.")
    @JsonProperty(JSON_PROPERTY_AUDIENCE_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAudienceOverride() {
        return audienceOverride;
    }

    @JsonProperty(JSON_PROPERTY_AUDIENCE_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public Saml11ApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {

        this.defaultRelayState = defaultRelayState;
        return this;
    }

    /**
     * The URL of the resource to direct users after they successfully sign in to the SP using SAML. See the SP
     * documentation to check if you need to specify a RelayState. In most instances, you can leave this field blank.
     *
     * @return defaultRelayState
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The URL of the resource to direct users after they successfully sign in to the SP using SAML. See the SP documentation to check if you need to specify a RelayState. In most instances, you can leave this field blank.")
    @JsonProperty(JSON_PROPERTY_DEFAULT_RELAY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getDefaultRelayState() {
        return defaultRelayState;
    }

    @JsonProperty(JSON_PROPERTY_DEFAULT_RELAY_STATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public Saml11ApplicationSettingsSignOn recipientOverride(String recipientOverride) {

        this.recipientOverride = recipientOverride;
        return this;
    }

    /**
     * The location where the application can present the SAML assertion. This is usually the Single Sign-On (SSO) URL.
     *
     * @return recipientOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The location where the application can present the SAML assertion. This is usually the Single Sign-On (SSO) URL.")
    @JsonProperty(JSON_PROPERTY_RECIPIENT_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getRecipientOverride() {
        return recipientOverride;
    }

    @JsonProperty(JSON_PROPERTY_RECIPIENT_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public Saml11ApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {

        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
        return this;
    }

    /**
     * Assertion Consumer Services (ACS) URL value for the Service Provider (SP). This URL is always used for Identity
     * Provider (IdP) initiated sign-on requests.
     *
     * @return ssoAcsUrlOverride
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Assertion Consumer Services (ACS) URL value for the Service Provider (SP). This URL is always used for Identity Provider (IdP) initiated sign-on requests.")
    @JsonProperty(JSON_PROPERTY_SSO_ACS_URL_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSsoAcsUrlOverride() {
        return ssoAcsUrlOverride;
    }

    @JsonProperty(JSON_PROPERTY_SSO_ACS_URL_OVERRIDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Saml11ApplicationSettingsSignOn saml11ApplicationSettingsSignOn = (Saml11ApplicationSettingsSignOn) o;
        return Objects.equals(this.audienceOverride, saml11ApplicationSettingsSignOn.audienceOverride)
                && Objects.equals(this.defaultRelayState, saml11ApplicationSettingsSignOn.defaultRelayState)
                && Objects.equals(this.recipientOverride, saml11ApplicationSettingsSignOn.recipientOverride)
                && Objects.equals(this.ssoAcsUrlOverride, saml11ApplicationSettingsSignOn.ssoAcsUrlOverride);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(audienceOverride, defaultRelayState, recipientOverride, ssoAcsUrlOverride);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Saml11ApplicationSettingsSignOn {\n");
        sb.append("    audienceOverride: ").append(toIndentedString(audienceOverride)).append("\n");
        sb.append("    defaultRelayState: ").append(toIndentedString(defaultRelayState)).append("\n");
        sb.append("    recipientOverride: ").append(toIndentedString(recipientOverride)).append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(toIndentedString(ssoAcsUrlOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
