package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Define custom attribute statements for the integration. These statements are inserted into the SAML assertions shared
 * with your app
 */
@ApiModel(description = "Define custom attribute statements for the integration. These statements are inserted into the SAML assertions shared with your app")
@JsonPropertyOrder({ SamlAttributeStatement.JSON_PROPERTY_FILTER_TYPE,
        SamlAttributeStatement.JSON_PROPERTY_FILTER_VALUE, SamlAttributeStatement.JSON_PROPERTY_NAME,
        SamlAttributeStatement.JSON_PROPERTY_NAMESPACE, SamlAttributeStatement.JSON_PROPERTY_TYPE,
        SamlAttributeStatement.JSON_PROPERTY_VALUES })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SamlAttributeStatement implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_FILTER_TYPE = "filterType";
    private String filterType;

    public static final String JSON_PROPERTY_FILTER_VALUE = "filterValue";
    private String filterValue;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_NAMESPACE = "namespace";
    private String namespace;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public static final String JSON_PROPERTY_VALUES = "values";
    private List<String> values = null;

    public SamlAttributeStatement() {
    }

    public SamlAttributeStatement filterType(String filterType) {

        this.filterType = filterType;
        return this;
    }

    /**
     * Get filterType
     *
     * @return filterType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FILTER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFilterType() {
        return filterType;
    }

    @JsonProperty(JSON_PROPERTY_FILTER_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFilterType(String filterType) {
        this.filterType = filterType;
    }

    public SamlAttributeStatement filterValue(String filterValue) {

        this.filterValue = filterValue;
        return this;
    }

    /**
     * Get filterValue
     *
     * @return filterValue
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_FILTER_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getFilterValue() {
        return filterValue;
    }

    @JsonProperty(JSON_PROPERTY_FILTER_VALUE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setFilterValue(String filterValue) {
        this.filterValue = filterValue;
    }

    public SamlAttributeStatement name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Get name
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SamlAttributeStatement namespace(String namespace) {

        this.namespace = namespace;
        return this;
    }

    /**
     * Get namespace
     *
     * @return namespace
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_NAMESPACE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getNamespace() {
        return namespace;
    }

    @JsonProperty(JSON_PROPERTY_NAMESPACE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public SamlAttributeStatement type(String type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public SamlAttributeStatement values(List<String> values) {

        this.values = values;
        return this;
    }

    public SamlAttributeStatement addvaluesItem(String valuesItem) {
        if (this.values == null) {
            this.values = new ArrayList<>();
        }
        this.values.add(valuesItem);
        return this;
    }

    /**
     * Get values
     *
     * @return values
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_VALUES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getValues() {
        return values;
    }

    @JsonProperty(JSON_PROPERTY_VALUES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setValues(List<String> values) {
        this.values = values;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SamlAttributeStatement samlAttributeStatement = (SamlAttributeStatement) o;
        return Objects.equals(this.filterType, samlAttributeStatement.filterType)
                && Objects.equals(this.filterValue, samlAttributeStatement.filterValue)
                && Objects.equals(this.name, samlAttributeStatement.name)
                && Objects.equals(this.namespace, samlAttributeStatement.namespace)
                && Objects.equals(this.type, samlAttributeStatement.type)
                && Objects.equals(this.values, samlAttributeStatement.values);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(filterType, filterValue, name, namespace, type, values);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlAttributeStatement {\n");
        sb.append("    filterType: ").append(toIndentedString(filterType)).append("\n");
        sb.append("    filterValue: ").append(toIndentedString(filterValue)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("    values: ").append(toIndentedString(values)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
