package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Security Events Provider with well-known URL setting
 */
@ApiModel(description = "Security Events Provider with well-known URL setting")
@JsonPropertyOrder({ SecurityEventsProviderSettingsSSFCompliant.JSON_PROPERTY_WELL_KNOWN_URL })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SecurityEventsProviderSettingsSSFCompliant implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_WELL_KNOWN_URL = "well_known_url";
    private String wellKnownUrl;

    public SecurityEventsProviderSettingsSSFCompliant() {
    }

    public SecurityEventsProviderSettingsSSFCompliant wellKnownUrl(String wellKnownUrl) {

        this.wellKnownUrl = wellKnownUrl;
        return this;
    }

    /**
     * The published well-known URL of the Security Events Provider (the SSF transmitter)
     *
     * @return wellKnownUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://example.okta.com/.well-known/ssf-configuration", required = true, value = "The published well-known URL of the Security Events Provider (the SSF transmitter)")
    @JsonProperty(JSON_PROPERTY_WELL_KNOWN_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public String getWellKnownUrl() {
        return wellKnownUrl;
    }

    @JsonProperty(JSON_PROPERTY_WELL_KNOWN_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setWellKnownUrl(String wellKnownUrl) {
        this.wellKnownUrl = wellKnownUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderSettingsSSFCompliant securityEventsProviderSettingsSSFCompliant = (SecurityEventsProviderSettingsSSFCompliant) o;
        return Objects.equals(this.wellKnownUrl, securityEventsProviderSettingsSSFCompliant.wellKnownUrl);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(wellKnownUrl);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderSettingsSSFCompliant {\n");
        sb.append("    wellKnownUrl: ").append(toIndentedString(wellKnownUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
