package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.SmsTemplateType;
import java.time.OffsetDateTime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SmsTemplate
 */
@JsonPropertyOrder({ SmsTemplate.JSON_PROPERTY_CREATED, SmsTemplate.JSON_PROPERTY_ID,
        SmsTemplate.JSON_PROPERTY_LAST_UPDATED, SmsTemplate.JSON_PROPERTY_NAME, SmsTemplate.JSON_PROPERTY_TEMPLATE,
        SmsTemplate.JSON_PROPERTY_TRANSLATIONS, SmsTemplate.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SmsTemplate implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template;

    public static final String JSON_PROPERTY_TRANSLATIONS = "translations";
    private Object translations;

    public static final String JSON_PROPERTY_TYPE = "type";
    private SmsTemplateType type;

    public SmsTemplate() {
    }

    /*
     * @JsonCreator public SmsTemplate(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated ) { this(); this.created = created; this.id
     * = id; this.lastUpdated = lastUpdated; }
     */

    /**
     * Get created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * Get id
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Get lastUpdated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    public SmsTemplate name(String name) {

        this.name = name;
        return this;
    }

    /**
     * Human-readable name of the Template
     *
     * @return name
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Human-readable name of the Template")
    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getName() {
        return name;
    }

    @JsonProperty(JSON_PROPERTY_NAME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public SmsTemplate template(String template) {

        this.template = template;
        return this;
    }

    /**
     * Text of the Template, including any
     * [macros](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Template/)
     *
     * @return template
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Text of the Template, including any [macros](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/Template/)")
    @JsonProperty(JSON_PROPERTY_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTemplate() {
        return template;
    }

    @JsonProperty(JSON_PROPERTY_TEMPLATE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(String template) {
        this.template = template;
    }

    public SmsTemplate translations(Object translations) {

        this.translations = translations;
        return this;
    }

    /**
     * - Template translations are optionally provided when you want to localize the SMS messages. Translations are
     * provided as an object that contains &#x60;key:value&#x60; pairs: the language and the translated Template text.
     * The key portion is a two-letter country code that conforms to [ISO
     * 639-1](https://www.loc.gov/standards/iso639-2/php/code_list.php). The value is the translated SMS Template. -
     * Just like with regular SMS Templates, the length of the SMS message can&#39;t exceed 160 characters.
     *
     * @return translations
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "- Template translations are optionally provided when you want to localize the SMS messages. Translations are provided as an object that contains `key:value` pairs: the language and the translated Template text. The key portion is a two-letter country code that conforms to [ISO 639-1](https://www.loc.gov/standards/iso639-2/php/code_list.php). The value is the translated SMS Template. - Just like with regular SMS Templates, the length of the SMS message can't exceed 160 characters. ")
    @JsonProperty(JSON_PROPERTY_TRANSLATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getTranslations() {
        return translations;
    }

    @JsonProperty(JSON_PROPERTY_TRANSLATIONS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setTranslations(Object translations) {
        this.translations = translations;
    }

    public SmsTemplate type(SmsTemplateType type) {

        this.type = type;
        return this;
    }

    /**
     * Get type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public SmsTemplateType getType() {
        return type;
    }

    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setType(SmsTemplateType type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SmsTemplate smsTemplate = (SmsTemplate) o;
        return Objects.equals(this.created, smsTemplate.created) && Objects.equals(this.id, smsTemplate.id)
                && Objects.equals(this.lastUpdated, smsTemplate.lastUpdated)
                && Objects.equals(this.name, smsTemplate.name) && Objects.equals(this.template, smsTemplate.template)
                && Objects.equals(this.translations, smsTemplate.translations)
                && Objects.equals(this.type, smsTemplate.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, name, template, translations, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SmsTemplate {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    name: ").append(toIndentedString(name)).append("\n");
        sb.append("    template: ").append(toIndentedString(template)).append("\n");
        sb.append("    translations: ").append(toIndentedString(translations)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
