package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * The Social Authentication Token object provides the tokens and associated metadata provided by social providers
 * during social authentication.
 */
@ApiModel(description = "The Social Authentication Token object provides the tokens and associated metadata provided by social providers during social authentication.")
@JsonPropertyOrder({ SocialAuthToken.JSON_PROPERTY_EXPIRES_AT, SocialAuthToken.JSON_PROPERTY_ID,
        SocialAuthToken.JSON_PROPERTY_SCOPES, SocialAuthToken.JSON_PROPERTY_TOKEN,
        SocialAuthToken.JSON_PROPERTY_TOKEN_AUTH_SCHEME, SocialAuthToken.JSON_PROPERTY_TOKEN_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class SocialAuthToken implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;

    public static final String JSON_PROPERTY_TOKEN = "token";
    private String token;

    public static final String JSON_PROPERTY_TOKEN_AUTH_SCHEME = "tokenAuthScheme";
    private String tokenAuthScheme;

    public static final String JSON_PROPERTY_TOKEN_TYPE = "tokenType";
    private String tokenType;

    public SocialAuthToken() {
    }

    /*
     * @JsonCreator public SocialAuthToken(
     *
     * @JsonProperty(JSON_PROPERTY_EXPIRES_AT) OffsetDateTime expiresAt,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_SCOPES) List<String> scopes,
     *
     * @JsonProperty(JSON_PROPERTY_TOKEN) String token,
     *
     * @JsonProperty(JSON_PROPERTY_TOKEN_AUTH_SCHEME) String tokenAuthScheme,
     *
     * @JsonProperty(JSON_PROPERTY_TOKEN_TYPE) String tokenType ) { this(); this.expiresAt = expiresAt; this.id = id;
     * this.scopes = scopes; this.token = token; this.tokenAuthScheme = tokenAuthScheme; this.tokenType = tokenType; }
     */

    /**
     * Timestamp when the object expires
     *
     * @return expiresAt
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2016-01-03T18:15:47Z", value = "Timestamp when the object expires")
    @JsonProperty(JSON_PROPERTY_EXPIRES_AT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getExpiresAt() {
        return expiresAt;
    }

    /**
     * Unique identifier for the token
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "NXp9GaX1eOA-XVF_H9fn2Q", value = "Unique identifier for the token")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * The scopes that the token is good for
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "[\"openid\",\"foo\"]", value = "The scopes that the token is good for")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getScopes() {
        return scopes;
    }

    /**
     * The raw token
     *
     * @return token
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "JBTWGV22G4ZGKV3N", value = "The raw token")
    @JsonProperty(JSON_PROPERTY_TOKEN)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getToken() {
        return token;
    }

    /**
     * The token authentication scheme as defined by the social provider
     *
     * @return tokenAuthScheme
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Bearer", value = "The token authentication scheme as defined by the social provider")
    @JsonProperty(JSON_PROPERTY_TOKEN_AUTH_SCHEME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenAuthScheme() {
        return tokenAuthScheme;
    }

    /**
     * The type of token defined by the [OAuth Token Exchange
     * Spec](https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-07#section-3)
     *
     * @return tokenType
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "urn:ietf:params:oauth:token-type:access_token", value = "The type of token defined by the [OAuth Token Exchange Spec](https://tools.ietf.org/html/draft-ietf-oauth-token-exchange-07#section-3)")
    @JsonProperty(JSON_PROPERTY_TOKEN_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getTokenType() {
        return tokenType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SocialAuthToken socialAuthToken = (SocialAuthToken) o;
        return Objects.equals(this.expiresAt, socialAuthToken.expiresAt) && Objects.equals(this.id, socialAuthToken.id)
                && Objects.equals(this.scopes, socialAuthToken.scopes)
                && Objects.equals(this.token, socialAuthToken.token)
                && Objects.equals(this.tokenAuthScheme, socialAuthToken.tokenAuthScheme)
                && Objects.equals(this.tokenType, socialAuthToken.tokenType);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(expiresAt, id, scopes, token, tokenAuthScheme, tokenType);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SocialAuthToken {\n");
        sb.append("    expiresAt: ").append(toIndentedString(expiresAt)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("    token: ").append(toIndentedString(token)).append("\n");
        sb.append("    tokenAuthScheme: ").append(toIndentedString(tokenAuthScheme)).append("\n");
        sb.append("    tokenType: ").append(toIndentedString(tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
