package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.net.URI;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * SAML test details
 */
@ApiModel(description = "SAML test details")
@JsonPropertyOrder({ TestInfoSamlTestConfiguration.JSON_PROPERTY_IDP, TestInfoSamlTestConfiguration.JSON_PROPERTY_SP,
        TestInfoSamlTestConfiguration.JSON_PROPERTY_JIT, TestInfoSamlTestConfiguration.JSON_PROPERTY_SP_INITIATE_URL,
        TestInfoSamlTestConfiguration.JSON_PROPERTY_SP_INITIATE_DESCRIPTION })
@JsonTypeName("TestInfo_samlTestConfiguration")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class TestInfoSamlTestConfiguration implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_IDP = "idp";
    private Boolean idp;

    public static final String JSON_PROPERTY_SP = "sp";
    private Boolean sp;

    public static final String JSON_PROPERTY_JIT = "jit";
    private Boolean jit;

    public static final String JSON_PROPERTY_SP_INITIATE_URL = "spInitiateUrl";
    private URI spInitiateUrl;

    public static final String JSON_PROPERTY_SP_INITIATE_DESCRIPTION = "spInitiateDescription";
    private String spInitiateDescription;

    public TestInfoSamlTestConfiguration() {
    }

    public TestInfoSamlTestConfiguration idp(Boolean idp) {

        this.idp = idp;
        return this;
    }

    /**
     * Indicates if your integration supports IdP-initiated sign-in
     *
     * @return idp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if your integration supports IdP-initiated sign-in")
    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getIdp() {
        return idp;
    }

    @JsonProperty(JSON_PROPERTY_IDP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setIdp(Boolean idp) {
        this.idp = idp;
    }

    public TestInfoSamlTestConfiguration sp(Boolean sp) {

        this.sp = sp;
        return this;
    }

    /**
     * Indicates if your integration supports SP-initiated sign-in
     *
     * @return sp
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if your integration supports SP-initiated sign-in")
    @JsonProperty(JSON_PROPERTY_SP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getSp() {
        return sp;
    }

    @JsonProperty(JSON_PROPERTY_SP)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSp(Boolean sp) {
        this.sp = sp;
    }

    public TestInfoSamlTestConfiguration jit(Boolean jit) {

        this.jit = jit;
        return this;
    }

    /**
     * Indicates if your integration supports Just-In-Time (JIT) provisioning
     *
     * @return jit
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Indicates if your integration supports Just-In-Time (JIT) provisioning")
    @JsonProperty(JSON_PROPERTY_JIT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Boolean getJit() {
        return jit;
    }

    @JsonProperty(JSON_PROPERTY_JIT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setJit(Boolean jit) {
        this.jit = jit;
    }

    public TestInfoSamlTestConfiguration spInitiateUrl(URI spInitiateUrl) {

        this.spInitiateUrl = spInitiateUrl;
        return this;
    }

    /**
     * URL for SP-initiated sign-in flows (required if &#x60;sp &#x3D; true&#x60;)
     *
     * @return spInitiateUrl
     **/
    @javax.annotation.Nonnull
    @ApiModelProperty(example = "https://test.example.com/strawberry/saml/sp-init", required = true, value = "URL for SP-initiated sign-in flows (required if `sp = true`)")
    @JsonProperty(JSON_PROPERTY_SP_INITIATE_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)

    public URI getSpInitiateUrl() {
        return spInitiateUrl;
    }

    @JsonProperty(JSON_PROPERTY_SP_INITIATE_URL)
    @JsonInclude(value = JsonInclude.Include.ALWAYS)
    public void setSpInitiateUrl(URI spInitiateUrl) {
        this.spInitiateUrl = spInitiateUrl;
    }

    public TestInfoSamlTestConfiguration spInitiateDescription(String spInitiateDescription) {

        this.spInitiateDescription = spInitiateDescription;
        return this;
    }

    /**
     * Instructions on how to sign in to your app using the SP-initiated flow (required if &#x60;sp &#x3D; true&#x60;)
     *
     * @return spInitiateDescription
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "Go to your app URL from a browser and enter your username", value = "Instructions on how to sign in to your app using the SP-initiated flow (required if `sp = true`)")
    @JsonProperty(JSON_PROPERTY_SP_INITIATE_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getSpInitiateDescription() {
        return spInitiateDescription;
    }

    @JsonProperty(JSON_PROPERTY_SP_INITIATE_DESCRIPTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setSpInitiateDescription(String spInitiateDescription) {
        this.spInitiateDescription = spInitiateDescription;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TestInfoSamlTestConfiguration testInfoSamlTestConfiguration = (TestInfoSamlTestConfiguration) o;
        return Objects.equals(this.idp, testInfoSamlTestConfiguration.idp)
                && Objects.equals(this.sp, testInfoSamlTestConfiguration.sp)
                && Objects.equals(this.jit, testInfoSamlTestConfiguration.jit)
                && Objects.equals(this.spInitiateUrl, testInfoSamlTestConfiguration.spInitiateUrl)
                && Objects.equals(this.spInitiateDescription, testInfoSamlTestConfiguration.spInitiateDescription);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(idp, sp, jit, spInitiateUrl, spInitiateDescription);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoSamlTestConfiguration {\n");
        sb.append("    idp: ").append(toIndentedString(idp)).append("\n");
        sb.append("    sp: ").append(toIndentedString(sp)).append("\n");
        sb.append("    jit: ").append(toIndentedString(jit)).append("\n");
        sb.append("    spInitiateUrl: ").append(toIndentedString(spInitiateUrl)).append("\n");
        sb.append("    spInitiateDescription: ").append(toIndentedString(spInitiateDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
