package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.BaseTokenLifetime;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * TokenPayLoadDataAccess
 */
@JsonPropertyOrder({ TokenPayLoadDataAccess.JSON_PROPERTY_CLAIMS, TokenPayLoadDataAccess.JSON_PROPERTY_LIFETIME,
        TokenPayLoadDataAccess.JSON_PROPERTY_SCOPES })
@JsonTypeName("TokenPayLoad_data_access")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class TokenPayLoadDataAccess implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private Object claims;

    public static final String JSON_PROPERTY_LIFETIME = "lifetime";
    private BaseTokenLifetime lifetime;

    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private Object scopes;

    public TokenPayLoadDataAccess() {
    }

    public TokenPayLoadDataAccess claims(Object claims) {

        this.claims = claims;
        return this;
    }

    /**
     * Claims included in the token. Consists of name-value pairs for each included claim. For descriptions of the
     * claims that you can include, see the Okta [OpenID Connect and OAuth 2.0 API
     * reference](/openapi/okta-oauth/guides/overview/#claims).
     *
     * @return claims
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Claims included in the token. Consists of name-value pairs for each included claim. For descriptions of the claims that you can include, see the Okta [OpenID Connect and OAuth 2.0 API reference](/openapi/okta-oauth/guides/overview/#claims).")
    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getClaims() {
        return claims;
    }

    @JsonProperty(JSON_PROPERTY_CLAIMS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(Object claims) {
        this.claims = claims;
    }

    public TokenPayLoadDataAccess lifetime(BaseTokenLifetime lifetime) {

        this.lifetime = lifetime;
        return this;
    }

    /**
     * Get lifetime
     *
     * @return lifetime
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public BaseTokenLifetime getLifetime() {
        return lifetime;
    }

    @JsonProperty(JSON_PROPERTY_LIFETIME)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLifetime(BaseTokenLifetime lifetime) {
        this.lifetime = lifetime;
    }

    public TokenPayLoadDataAccess scopes(Object scopes) {

        this.scopes = scopes;
        return this;
    }

    /**
     * The scopes contained in the token. For descriptions of the scopes that you can include, see the Okta [OpenID
     * Connect and OAuth 2.0 API reference](/openapi/okta-oauth/guides/overview/#scopes).
     *
     * @return scopes
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The scopes contained in the token. For descriptions of the scopes that you can include, see the Okta [OpenID Connect and OAuth 2.0 API reference](/openapi/okta-oauth/guides/overview/#scopes).")
    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Object getScopes() {
        return scopes;
    }

    @JsonProperty(JSON_PROPERTY_SCOPES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(Object scopes) {
        this.scopes = scopes;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TokenPayLoadDataAccess tokenPayLoadDataAccess = (TokenPayLoadDataAccess) o;
        return Objects.equals(this.claims, tokenPayLoadDataAccess.claims)
                && Objects.equals(this.lifetime, tokenPayLoadDataAccess.lifetime)
                && Objects.equals(this.scopes, tokenPayLoadDataAccess.scopes);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(claims, lifetime, scopes);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenPayLoadDataAccess {\n");
        sb.append("    claims: ").append(toIndentedString(claims)).append("\n");
        sb.append("    lifetime: ").append(toIndentedString(lifetime)).append("\n");
        sb.append("    scopes: ").append(toIndentedString(scopes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
