package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorSecurityQuestionProfile
 */
@JsonPropertyOrder({ UserFactorSecurityQuestionProfile.JSON_PROPERTY_ANSWER,
        UserFactorSecurityQuestionProfile.JSON_PROPERTY_QUESTION,
        UserFactorSecurityQuestionProfile.JSON_PROPERTY_QUESTION_TEXT })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserFactorSecurityQuestionProfile implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ANSWER = "answer";
    private String answer;

    /**
     * Unique key for the question
     */
    public enum QuestionEnum {
        DISLIKED_FOOD(String.valueOf("disliked_food")),

        NAME_OF_FIRST_PLUSH_TOY(String.valueOf("name_of_first_plush_toy")),

        FIRST_AWARD(String.valueOf("first_award")),

        FAVORITE_SECURITY_QUESTION(String.valueOf("favorite_security_question")),

        FAVORITE_TOY(String.valueOf("favorite_toy")),

        FIRST_COMPUTER_GAME(String.valueOf("first_computer_game")),

        FAVORITE_MOVIE_QUOTE(String.valueOf("favorite_movie_quote")),

        FIRST_SPORTS_TEAM_MASCOT(String.valueOf("first_sports_team_mascot")),

        FIRST_MUSIC_PURCHASE(String.valueOf("first_music_purchase")),

        FAVORITE_ART_PIECE(String.valueOf("favorite_art_piece")),

        GRANDMOTHER_FAVORITE_DESERT(String.valueOf("grandmother_favorite_desert")),

        FIRST_THING_COOKED(String.valueOf("first_thing_cooked")),

        CHILDHOOD_DREAM_JOB(String.valueOf("childhood_dream_job")),

        FIRST_KISS_LOCATION(String.valueOf("first_kiss_location")),

        PLACE_WHERE_SIGNIFICANT_OTHER_WAS_MET(String.valueOf("place_where_significant_other_was_met")),

        FAVORITE_VACATION_LOCATION(String.valueOf("favorite_vacation_location")),

        NEW_YEARS_TWO_THOUSAND(String.valueOf("new_years_two_thousand")),

        FAVORITE_SPEAKER_ACTOR(String.valueOf("favorite_speaker_actor")),

        FAVORITE_BOOK_MOVIE_CHARACTER(String.valueOf("favorite_book_movie_character")),

        FAVORITE_SPORTS_PLAYER(String.valueOf("favorite_sports_player")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        QuestionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static QuestionEnum fromValue(String value) {
            for (QuestionEnum b : QuestionEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_QUESTION = "question";
    private QuestionEnum question;

    public static final String JSON_PROPERTY_QUESTION_TEXT = "questionText";
    private String questionText;

    public UserFactorSecurityQuestionProfile() {
    }

    /*
     * @JsonCreator public UserFactorSecurityQuestionProfile(
     *
     * @JsonProperty(JSON_PROPERTY_QUESTION_TEXT) String questionText ) { this(); this.questionText = questionText; }
     */

    public UserFactorSecurityQuestionProfile answer(String answer) {

        this.answer = answer;
        return this;
    }

    /**
     * Answer to the question
     *
     * @return answer
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Answer to the question")
    @JsonProperty(JSON_PROPERTY_ANSWER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getAnswer() {
        return answer;
    }

    @JsonProperty(JSON_PROPERTY_ANSWER)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public UserFactorSecurityQuestionProfile question(QuestionEnum question) {

        this.question = question;
        return this;
    }

    /**
     * Unique key for the question
     *
     * @return question
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "disliked_food", value = "Unique key for the question")
    @JsonProperty(JSON_PROPERTY_QUESTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public QuestionEnum getQuestion() {
        return question;
    }

    @JsonProperty(JSON_PROPERTY_QUESTION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setQuestion(QuestionEnum question) {
        this.question = question;
    }

    /**
     * Human-readable text that&#39;s displayed to the user
     *
     * @return questionText
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "What is the food you least liked as a child?", value = "Human-readable text that's displayed to the user")
    @JsonProperty(JSON_PROPERTY_QUESTION_TEXT)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getQuestionText() {
        return questionText;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorSecurityQuestionProfile userFactorSecurityQuestionProfile = (UserFactorSecurityQuestionProfile) o;
        return Objects.equals(this.answer, userFactorSecurityQuestionProfile.answer)
                && Objects.equals(this.question, userFactorSecurityQuestionProfile.question)
                && Objects.equals(this.questionText, userFactorSecurityQuestionProfile.questionText);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(answer, question, questionText);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorSecurityQuestionProfile {\n");
        sb.append("    answer: ").append(toIndentedString(answer)).append("\n");
        sb.append("    question: ").append(toIndentedString(question)).append("\n");
        sb.append("    questionText: ").append(toIndentedString(questionText)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
