package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserFactorLinks;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * UserFactorYubikeyOtpToken
 */
@JsonPropertyOrder({ UserFactorYubikeyOtpToken.JSON_PROPERTY_CREATED, UserFactorYubikeyOtpToken.JSON_PROPERTY_ID,
        UserFactorYubikeyOtpToken.JSON_PROPERTY_LAST_UPDATED, UserFactorYubikeyOtpToken.JSON_PROPERTY_LAST_VERIFIED,
        UserFactorYubikeyOtpToken.JSON_PROPERTY_PROFILE, UserFactorYubikeyOtpToken.JSON_PROPERTY_STATUS,
        UserFactorYubikeyOtpToken.JSON_PROPERTY_EMBEDDED, UserFactorYubikeyOtpToken.JSON_PROPERTY_LINKS })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserFactorYubikeyOtpToken implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;

    public static final String JSON_PROPERTY_LAST_VERIFIED = "lastVerified";
    private OffsetDateTime lastVerified;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;

    /**
     * Token status
     */
    public enum StatusEnum {
        BLOCKED(String.valueOf("BLOCKED")),

        UNASSIGNED(String.valueOf("UNASSIGNED")),

        ACTIVE(String.valueOf("ACTIVE")),

        REVOKED(String.valueOf("REVOKED")),

        DELETED(String.valueOf("DELETED")),

        INACTIVE(String.valueOf("INACTIVE")),

        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        StatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return value;
        }

        @Override
        public String toString() {
            return String.valueOf(value);
        }

        @JsonCreator
        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (b.value.equals(value)) {
                    return b;
                }
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static final String JSON_PROPERTY_STATUS = "status";
    private StatusEnum status;

    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;

    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    public UserFactorYubikeyOtpToken() {
    }

    /*
     * @JsonCreator public UserFactorYubikeyOtpToken(
     *
     * @JsonProperty(JSON_PROPERTY_CREATED) OffsetDateTime created,
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_UPDATED) OffsetDateTime lastUpdated,
     *
     * @JsonProperty(JSON_PROPERTY_LAST_VERIFIED) OffsetDateTime lastVerified ) { this(); this.created = created;
     * this.id = id; this.lastUpdated = lastUpdated; this.lastVerified = lastVerified; }
     */

    /**
     * Timestamp when the Token was created
     *
     * @return created
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the Token was created")
    @JsonProperty(JSON_PROPERTY_CREATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getCreated() {
        return created;
    }

    /**
     * ID of the Token
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "ykkwcx13nrDq8g4oy0g3", value = "ID of the Token")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    /**
     * Timestamp when the Token was last updated
     *
     * @return lastUpdated
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the Token was last updated")
    @JsonProperty(JSON_PROPERTY_LAST_UPDATED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastUpdated() {
        return lastUpdated;
    }

    /**
     * Timestamp when the Token was last verified
     *
     * @return lastVerified
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(example = "2022-08-25T00:31Z", value = "Timestamp when the Token was last verified")
    @JsonProperty(JSON_PROPERTY_LAST_VERIFIED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public OffsetDateTime getLastVerified() {
        return lastVerified;
    }

    public UserFactorYubikeyOtpToken profile(Map<String, Object> profile) {

        this.profile = profile;
        return this;
    }

    public UserFactorYubikeyOtpToken putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * Specified profile information for token
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Specified profile information for token")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public UserFactorYubikeyOtpToken status(StatusEnum status) {

        this.status = status;
        return this;
    }

    /**
     * Token status
     *
     * @return status
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Token status")
    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public StatusEnum getStatus() {
        return status;
    }

    @JsonProperty(JSON_PROPERTY_STATUS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public UserFactorYubikeyOtpToken embedded(Map<String, Object> embedded) {

        this.embedded = embedded;
        return this;
    }

    public UserFactorYubikeyOtpToken putembeddedItem(String key, Object embeddedItem) {
        if (this.embedded == null) {
            this.embedded = new HashMap<>();
        }
        this.embedded.put(key, embeddedItem);
        return this;
    }

    /**
     * Get embedded
     *
     * @return embedded
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, Object> getEmbedded() {
        return embedded;
    }

    @JsonProperty(JSON_PROPERTY_EMBEDDED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(Map<String, Object> embedded) {
        this.embedded = embedded;
    }

    public UserFactorYubikeyOtpToken links(UserFactorLinks links) {

        this.links = links;
        return this;
    }

    /**
     * Get links
     *
     * @return links
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserFactorLinks getLinks() {
        return links;
    }

    @JsonProperty(JSON_PROPERTY_LINKS)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserFactorYubikeyOtpToken userFactorYubikeyOtpToken = (UserFactorYubikeyOtpToken) o;
        return Objects.equals(this.created, userFactorYubikeyOtpToken.created)
                && Objects.equals(this.id, userFactorYubikeyOtpToken.id)
                && Objects.equals(this.lastUpdated, userFactorYubikeyOtpToken.lastUpdated)
                && Objects.equals(this.lastVerified, userFactorYubikeyOtpToken.lastVerified)
                && Objects.equals(this.profile, userFactorYubikeyOtpToken.profile)
                && Objects.equals(this.status, userFactorYubikeyOtpToken.status)
                && Objects.equals(this.embedded, userFactorYubikeyOtpToken.embedded)
                && Objects.equals(this.links, userFactorYubikeyOtpToken.links);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(created, id, lastUpdated, lastVerified, profile, status, embedded, links);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactorYubikeyOtpToken {\n");
        sb.append("    created: ").append(toIndentedString(created)).append("\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    lastUpdated: ").append(toIndentedString(lastUpdated)).append("\n");
        sb.append("    lastVerified: ").append(toIndentedString(lastVerified)).append("\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    embedded: ").append(toIndentedString(embedded)).append("\n");
        sb.append("    links: ").append(toIndentedString(links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
