package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Provides information on the Okta user profile currently set to be used for the user who is being imported, based on
 * the matching rules and attribute mappings that were applied.
 */
@ApiModel(description = "Provides information on the Okta user profile currently set to be used for the user who is being imported, based on the matching  rules and attribute mappings that were applied.")
@JsonPropertyOrder({ UserImportRequestDataUser.JSON_PROPERTY_PROFILE })
@JsonTypeName("UserImportRequestData_user")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserImportRequestDataUser implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, String> profile = null;

    public UserImportRequestDataUser() {
    }

    public UserImportRequestDataUser profile(Map<String, String> profile) {

        this.profile = profile;
        return this;
    }

    public UserImportRequestDataUser putprofileItem(String key, String profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    /**
     * The &#x60;data.user.profile&#x60; contains the name-value pairs of the attributes in the user profile. If the
     * user has been matched to an existing Okta user, a &#x60;data.user.id&#x60; object is included, containing the
     * unique identifier of the Okta user profile. You can change the values of the attributes by means of the
     * &#x60;commands&#x60; object you return.
     *
     * @return profile
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `data.user.profile` contains the name-value pairs of the attributes in the user profile. If the user has been matched to an existing Okta user, a `data.user.id` object is included, containing the unique identifier of the Okta user profile.  You can change the values of the attributes by means of the `commands` object you return.")
    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public Map<String, String> getProfile() {
        return profile;
    }

    @JsonProperty(JSON_PROPERTY_PROFILE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, String> profile) {
        this.profile = profile;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserImportRequestDataUser userImportRequestDataUser = (UserImportRequestDataUser) o;
        return Objects.equals(this.profile, userImportRequestDataUser.profile);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserImportRequestDataUser {\n");
        sb.append("    profile: ").append(toIndentedString(profile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
