package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.InactivityPolicyRuleCondition;
import com.okta.sdk.resource.model.LifecycleExpirationPolicyRuleCondition;
import com.okta.sdk.resource.model.PasswordExpirationPolicyRuleCondition;
import com.okta.sdk.resource.model.UserLifecycleAttributePolicyRuleCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * Specifies a set of Users to be included or excluded
 */
@ApiModel(description = "Specifies a set of Users to be included or excluded")
@JsonPropertyOrder({ UserPolicyRuleCondition.JSON_PROPERTY_EXCLUDE, UserPolicyRuleCondition.JSON_PROPERTY_INACTIVITY,
        UserPolicyRuleCondition.JSON_PROPERTY_INCLUDE, UserPolicyRuleCondition.JSON_PROPERTY_LIFECYCLE_EXPIRATION,
        UserPolicyRuleCondition.JSON_PROPERTY_PASSWORD_EXPIRATION,
        UserPolicyRuleCondition.JSON_PROPERTY_USER_LIFECYCLE_ATTRIBUTE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserPolicyRuleCondition implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private List<String> exclude = null;

    public static final String JSON_PROPERTY_INACTIVITY = "inactivity";
    private InactivityPolicyRuleCondition inactivity;

    public static final String JSON_PROPERTY_INCLUDE = "include";
    private List<String> include = null;

    public static final String JSON_PROPERTY_LIFECYCLE_EXPIRATION = "lifecycleExpiration";
    private LifecycleExpirationPolicyRuleCondition lifecycleExpiration;

    public static final String JSON_PROPERTY_PASSWORD_EXPIRATION = "passwordExpiration";
    private PasswordExpirationPolicyRuleCondition passwordExpiration;

    public static final String JSON_PROPERTY_USER_LIFECYCLE_ATTRIBUTE = "userLifecycleAttribute";
    private UserLifecycleAttributePolicyRuleCondition userLifecycleAttribute;

    public UserPolicyRuleCondition() {
    }

    public UserPolicyRuleCondition exclude(List<String> exclude) {

        this.exclude = exclude;
        return this;
    }

    public UserPolicyRuleCondition addexcludeItem(String excludeItem) {
        if (this.exclude == null) {
            this.exclude = new ArrayList<>();
        }
        this.exclude.add(excludeItem);
        return this;
    }

    /**
     * Users to be excluded
     *
     * @return exclude
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Users to be excluded")
    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getExclude() {
        return exclude;
    }

    @JsonProperty(JSON_PROPERTY_EXCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(List<String> exclude) {
        this.exclude = exclude;
    }

    public UserPolicyRuleCondition inactivity(InactivityPolicyRuleCondition inactivity) {

        this.inactivity = inactivity;
        return this;
    }

    /**
     * Get inactivity
     *
     * @return inactivity
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_INACTIVITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public InactivityPolicyRuleCondition getInactivity() {
        return inactivity;
    }

    @JsonProperty(JSON_PROPERTY_INACTIVITY)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInactivity(InactivityPolicyRuleCondition inactivity) {
        this.inactivity = inactivity;
    }

    public UserPolicyRuleCondition include(List<String> include) {

        this.include = include;
        return this;
    }

    public UserPolicyRuleCondition addincludeItem(String includeItem) {
        if (this.include == null) {
            this.include = new ArrayList<>();
        }
        this.include.add(includeItem);
        return this;
    }

    /**
     * Users to be included
     *
     * @return include
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "Users to be included")
    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getInclude() {
        return include;
    }

    @JsonProperty(JSON_PROPERTY_INCLUDE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setInclude(List<String> include) {
        this.include = include;
    }

    public UserPolicyRuleCondition lifecycleExpiration(LifecycleExpirationPolicyRuleCondition lifecycleExpiration) {

        this.lifecycleExpiration = lifecycleExpiration;
        return this;
    }

    /**
     * Get lifecycleExpiration
     *
     * @return lifecycleExpiration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_LIFECYCLE_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public LifecycleExpirationPolicyRuleCondition getLifecycleExpiration() {
        return lifecycleExpiration;
    }

    @JsonProperty(JSON_PROPERTY_LIFECYCLE_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setLifecycleExpiration(LifecycleExpirationPolicyRuleCondition lifecycleExpiration) {
        this.lifecycleExpiration = lifecycleExpiration;
    }

    public UserPolicyRuleCondition passwordExpiration(PasswordExpirationPolicyRuleCondition passwordExpiration) {

        this.passwordExpiration = passwordExpiration;
        return this;
    }

    /**
     * Get passwordExpiration
     *
     * @return passwordExpiration
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_PASSWORD_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public PasswordExpirationPolicyRuleCondition getPasswordExpiration() {
        return passwordExpiration;
    }

    @JsonProperty(JSON_PROPERTY_PASSWORD_EXPIRATION)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setPasswordExpiration(PasswordExpirationPolicyRuleCondition passwordExpiration) {
        this.passwordExpiration = passwordExpiration;
    }

    public UserPolicyRuleCondition userLifecycleAttribute(
            UserLifecycleAttributePolicyRuleCondition userLifecycleAttribute) {

        this.userLifecycleAttribute = userLifecycleAttribute;
        return this;
    }

    /**
     * Get userLifecycleAttribute
     *
     * @return userLifecycleAttribute
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "")
    @JsonProperty(JSON_PROPERTY_USER_LIFECYCLE_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserLifecycleAttributePolicyRuleCondition getUserLifecycleAttribute() {
        return userLifecycleAttribute;
    }

    @JsonProperty(JSON_PROPERTY_USER_LIFECYCLE_ATTRIBUTE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setUserLifecycleAttribute(UserLifecycleAttributePolicyRuleCondition userLifecycleAttribute) {
        this.userLifecycleAttribute = userLifecycleAttribute;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserPolicyRuleCondition userPolicyRuleCondition = (UserPolicyRuleCondition) o;
        return Objects.equals(this.exclude, userPolicyRuleCondition.exclude)
                && Objects.equals(this.inactivity, userPolicyRuleCondition.inactivity)
                && Objects.equals(this.include, userPolicyRuleCondition.include)
                && Objects.equals(this.lifecycleExpiration, userPolicyRuleCondition.lifecycleExpiration)
                && Objects.equals(this.passwordExpiration, userPolicyRuleCondition.passwordExpiration)
                && Objects.equals(this.userLifecycleAttribute, userPolicyRuleCondition.userLifecycleAttribute);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(exclude, inactivity, include, lifecycleExpiration, passwordExpiration,
                userLifecycleAttribute);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserPolicyRuleCondition {\n");
        sb.append("    exclude: ").append(toIndentedString(exclude)).append("\n");
        sb.append("    inactivity: ").append(toIndentedString(inactivity)).append("\n");
        sb.append("    include: ").append(toIndentedString(include)).append("\n");
        sb.append("    lifecycleExpiration: ").append(toIndentedString(lifecycleExpiration)).append("\n");
        sb.append("    passwordExpiration: ").append(toIndentedString(passwordExpiration)).append("\n");
        sb.append("    userLifecycleAttribute: ").append(toIndentedString(userLifecycleAttribute)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
