package com.okta.sdk.resource.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.UserSchemaBaseProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiModel;

/**
 * All Okta-defined Profile properties are defined in a Profile subschema with the resolution scope &#x60;#base&#x60;.
 * You can&#39;t modify these properties, except to update permissions, to change the nullability of
 * &#x60;firstName&#x60; and &#x60;lastName&#x60;, or to specify a pattern for &#x60;login&#x60;. They can&#39;t be
 * removed. The base User Profile is based on the [System for Cross-domain Identity Management: Core
 * Schema](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#section-4.1.1) and has the standard properties
 * detailed below.
 */
@ApiModel(description = "All Okta-defined Profile properties are defined in a Profile subschema with the resolution scope `#base`. You can't modify these properties, except to update permissions, to change the nullability of `firstName` and `lastName`, or to specify a pattern for `login`. They can't be removed.  The base User Profile is based on the [System for Cross-domain Identity Management: Core Schema](https://tools.ietf.org/html/draft-ietf-scim-core-schema-22#section-4.1.1) and has the standard properties detailed below.")
@JsonPropertyOrder({ UserSchemaBase.JSON_PROPERTY_ID, UserSchemaBase.JSON_PROPERTY_PROPERTIES,
        UserSchemaBase.JSON_PROPERTY_REQUIRED, UserSchemaBase.JSON_PROPERTY_TYPE })
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2025-02-24T22:29:38.763116-06:00[America/Chicago]", comments = "Generator version: 7.11.0")
public class UserSchemaBase implements Serializable {

    private static final long serialVersionUID = 1L;

    public static final String JSON_PROPERTY_ID = "id";
    private String id;

    public static final String JSON_PROPERTY_PROPERTIES = "properties";
    private UserSchemaBaseProperties properties;

    public static final String JSON_PROPERTY_REQUIRED = "required";
    private List<String> required = null;

    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;

    public UserSchemaBase() {
    }

    /*
     * @JsonCreator public UserSchemaBase(
     *
     * @JsonProperty(JSON_PROPERTY_ID) String id,
     *
     * @JsonProperty(JSON_PROPERTY_REQUIRED) List<String> required,
     *
     * @JsonProperty(JSON_PROPERTY_TYPE) String type ) { this(); this.id = id; this.required = required; this.type =
     * type; }
     */

    /**
     * The subschema name
     *
     * @return id
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The subschema name")
    @JsonProperty(JSON_PROPERTY_ID)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getId() {
        return id;
    }

    public UserSchemaBase properties(UserSchemaBaseProperties properties) {

        this.properties = properties;
        return this;
    }

    /**
     * The &#x60;#base&#x60; object properties
     *
     * @return properties
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The `#base` object properties")
    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public UserSchemaBaseProperties getProperties() {
        return properties;
    }

    @JsonProperty(JSON_PROPERTY_PROPERTIES)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
    public void setProperties(UserSchemaBaseProperties properties) {
        this.properties = properties;
    }

    /**
     * A collection indicating required property names
     *
     * @return required
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "A collection indicating required property names")
    @JsonProperty(JSON_PROPERTY_REQUIRED)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public List<String> getRequired() {
        return required;
    }

    /**
     * The object type
     *
     * @return type
     **/
    @javax.annotation.Nullable
    @ApiModelProperty(value = "The object type")
    @JsonProperty(JSON_PROPERTY_TYPE)
    @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

    public String getType() {
        return type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        UserSchemaBase userSchemaBase = (UserSchemaBase) o;
        return Objects.equals(this.id, userSchemaBase.id) && Objects.equals(this.properties, userSchemaBase.properties)
                && Objects.equals(this.required, userSchemaBase.required)
                && Objects.equals(this.type, userSchemaBase.type);
        // ;
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, properties, required, type);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserSchemaBase {\n");
        sb.append("    id: ").append(toIndentedString(id)).append("\n");
        sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
        sb.append("    required: ").append(toIndentedString(required)).append("\n");
        sb.append("    type: ").append(toIndentedString(type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
