/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.CatalogApplication;
import com.okta.sdk.resource.model.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class RoleBTargetBGroupApi {
    private ApiClient apiClient;

    public RoleBTargetBGroupApi() {
        this(Configuration.getDefaultApiClient());
    }

    public RoleBTargetBGroupApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public void assignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleAssignmentId, String appName, String appId) throws ApiException {
        this.assignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    public void assignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleAssignmentId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling assignAppInstanceTargetToAppAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignAppTargetToAdminRoleForGroup(String groupId, String roleAssignmentId, String appName) throws ApiException {
        this.assignAppTargetToAdminRoleForGroup(groupId, roleAssignmentId, appName, Collections.emptyMap());
    }

    public void assignAppTargetToAdminRoleForGroup(String groupId, String roleAssignmentId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignAppTargetToAdminRoleForGroup");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignAppTargetToAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling assignAppTargetToAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void assignGroupTargetToGroupAdminRole(String groupId, String roleAssignmentId, String targetGroupId) throws ApiException {
        this.assignGroupTargetToGroupAdminRole(groupId, roleAssignmentId, targetGroupId, Collections.emptyMap());
    }

    public void assignGroupTargetToGroupAdminRole(String groupId, String roleAssignmentId, String targetGroupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling assignGroupTargetToGroupAdminRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling assignGroupTargetToGroupAdminRole");
        }
        if (targetGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'targetGroupId' when calling assignGroupTargetToGroupAdminRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/groups/{targetGroupId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{targetGroupId\\}", this.apiClient.escapeString(targetGroupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listApplicationTargetsForApplicationAdministratorRoleForGroup(groupId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public List<CatalogApplication> listApplicationTargetsForApplicationAdministratorRoleForGroup(String groupId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling listApplicationTargetsForApplicationAdministratorRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<CatalogApplication>> localVarReturnType = new TypeReference<List<CatalogApplication>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<Group> listGroupTargetsForGroupRole(String groupId, String roleAssignmentId, String after, Integer limit) throws ApiException {
        return this.listGroupTargetsForGroupRole(groupId, roleAssignmentId, after, limit, Collections.emptyMap());
    }

    public List<Group> listGroupTargetsForGroupRole(String groupId, String roleAssignmentId, String after, Integer limit, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling listGroupTargetsForGroupRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling listGroupTargetsForGroupRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/groups".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarQueryParams.addAll(this.apiClient.parameterToPair("after", after));
        localVarQueryParams.addAll(this.apiClient.parameterToPair("limit", limit));
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<Group>> localVarReturnType = new TypeReference<List<Group>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void unassignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleAssignmentId, String appName, String appId) throws ApiException {
        this.unassignAppInstanceTargetToAppAdminRoleForGroup(groupId, roleAssignmentId, appName, appId, Collections.emptyMap());
    }

    public void unassignAppInstanceTargetToAppAdminRoleForGroup(String groupId, String roleAssignmentId, String appName, String appId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        if (appId == null) {
            throw new ApiException(400, "Missing the required parameter 'appId' when calling unassignAppInstanceTargetToAppAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}/{appId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString())).replaceAll("\\{appId\\}", this.apiClient.escapeString(appId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignAppTargetToAdminRoleForGroup(String groupId, String roleAssignmentId, String appName) throws ApiException {
        this.unassignAppTargetToAdminRoleForGroup(groupId, roleAssignmentId, appName, Collections.emptyMap());
    }

    public void unassignAppTargetToAdminRoleForGroup(String groupId, String roleAssignmentId, String appName, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignAppTargetToAdminRoleForGroup");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignAppTargetToAdminRoleForGroup");
        }
        if (appName == null) {
            throw new ApiException(400, "Missing the required parameter 'appName' when calling unassignAppTargetToAdminRoleForGroup");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/catalog/apps/{appName}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{appName\\}", this.apiClient.escapeString(appName.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public void unassignGroupTargetFromGroupAdminRole(String groupId, String roleAssignmentId, String targetGroupId) throws ApiException {
        this.unassignGroupTargetFromGroupAdminRole(groupId, roleAssignmentId, targetGroupId, Collections.emptyMap());
    }

    public void unassignGroupTargetFromGroupAdminRole(String groupId, String roleAssignmentId, String targetGroupId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (groupId == null) {
            throw new ApiException(400, "Missing the required parameter 'groupId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        if (roleAssignmentId == null) {
            throw new ApiException(400, "Missing the required parameter 'roleAssignmentId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        if (targetGroupId == null) {
            throw new ApiException(400, "Missing the required parameter 'targetGroupId' when calling unassignGroupTargetFromGroupAdminRole");
        }
        String localVarPath = "/api/v1/groups/{groupId}/roles/{roleAssignmentId}/targets/groups/{targetGroupId}".replaceAll("\\{groupId\\}", this.apiClient.escapeString(groupId.toString())).replaceAll("\\{roleAssignmentId\\}", this.apiClient.escapeString(roleAssignmentId.toString())).replaceAll("\\{targetGroupId\\}", this.apiClient.escapeString(targetGroupId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

