/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.ApplicationAccessibility;
import com.okta.sdk.resource.model.ApplicationEmbedded;
import com.okta.sdk.resource.model.ApplicationLicensing;
import com.okta.sdk.resource.model.ApplicationLifecycleStatus;
import com.okta.sdk.resource.model.ApplicationLinks;
import com.okta.sdk.resource.model.ApplicationSignOnMode;
import com.okta.sdk.resource.model.ApplicationVisibility;
import com.okta.sdk.resource.model.AutoLoginApplication;
import com.okta.sdk.resource.model.BasicAuthApplication;
import com.okta.sdk.resource.model.BookmarkApplication;
import com.okta.sdk.resource.model.BrowserPluginApplication;
import com.okta.sdk.resource.model.OpenIdConnectApplication;
import com.okta.sdk.resource.model.Saml11Application;
import com.okta.sdk.resource.model.SamlApplication;
import com.okta.sdk.resource.model.SecurePasswordStoreApplication;
import com.okta.sdk.resource.model.WsFederationApplication;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"accessibility", "created", "features", "id", "label", "lastUpdated", "licensing", "orn", "profile", "signOnMode", "status", "visibility", "_embedded", "_links"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="signOnMode", visible=true, defaultImpl=Application.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=AutoLoginApplication.class, name="AUTO_LOGIN"), @JsonSubTypes.Type(value=BasicAuthApplication.class, name="BASIC_AUTH"), @JsonSubTypes.Type(value=BookmarkApplication.class, name="BOOKMARK"), @JsonSubTypes.Type(value=BrowserPluginApplication.class, name="BROWSER_PLUGIN"), @JsonSubTypes.Type(value=OpenIdConnectApplication.class, name="OPENID_CONNECT"), @JsonSubTypes.Type(value=Saml11Application.class, name="SAML_1_1"), @JsonSubTypes.Type(value=SamlApplication.class, name="SAML_2_0"), @JsonSubTypes.Type(value=SecurePasswordStoreApplication.class, name="SECURE_PASSWORD_STORE"), @JsonSubTypes.Type(value=WsFederationApplication.class, name="WS_FEDERATION")})
public class Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESSIBILITY = "accessibility";
    private ApplicationAccessibility accessibility;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_FEATURES = "features";
    private List<FeaturesEnum> features = null;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LABEL = "label";
    private String label;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_LICENSING = "licensing";
    private ApplicationLicensing licensing;
    public static final String JSON_PROPERTY_ORN = "orn";
    private String orn;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_SIGN_ON_MODE = "signOnMode";
    protected ApplicationSignOnMode signOnMode;
    public static final String JSON_PROPERTY_STATUS = "status";
    private ApplicationLifecycleStatus status;
    public static final String JSON_PROPERTY_VISIBILITY = "visibility";
    private ApplicationVisibility visibility;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private ApplicationEmbedded embedded;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private ApplicationLinks links;

    public Application accessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationAccessibility getAccessibility() {
        return this.accessibility;
    }

    @JsonProperty(value="accessibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessibility(ApplicationAccessibility accessibility) {
        this.accessibility = accessibility;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the Application object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public Application features(List<FeaturesEnum> features) {
        this.features = features;
        return this;
    }

    public Application addfeaturesItem(FeaturesEnum featuresItem) {
        if (this.features == null) {
            this.features = new ArrayList<FeaturesEnum>();
        }
        this.features.add(featuresItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Enabled app features > **Note:** Some apps can support optional provisioning features. See [Application Features](/openapi/okta-management/management/tag/ApplicationFeatures/) ")
    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<FeaturesEnum> getFeatures() {
        return this.features;
    }

    @JsonProperty(value="features")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFeatures(List<FeaturesEnum> features) {
        this.features = features;
    }

    @Nullable
    @ApiModelProperty(value="Unique ID for the app instance")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    public Application label(String label) {
        this.label = label;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="User-defined display name for app")
    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLabel(String label) {
        this.label = label;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the Application object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public Application licensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLicensing getLicensing() {
        return this.licensing;
    }

    @JsonProperty(value="licensing")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLicensing(ApplicationLicensing licensing) {
        this.licensing = licensing;
    }

    @Nullable
    @ApiModelProperty(value="The Okta resource name (ORN) for the current app instance")
    @JsonProperty(value="orn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOrn() {
        return this.orn;
    }

    public Application profile(Map<String, Object> profile) {
        this.profile = profile;
        return this;
    }

    public Application putprofileItem(String key, Object profileItem) {
        if (this.profile == null) {
            this.profile = new HashMap<String, Object>();
        }
        this.profile.put(key, profileItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Contains any valid JSON schema for specifying properties that can be referenced from a request (only available to OAuth 2.0 client apps). For example, add an app manager contact email address or define an allowlist of groups that you can then reference using the Okta Expression Language `getFilteredGroups` function.  > **Notes:** > * `profile` isn't encrypted, so don't store sensitive data in it. > * `profile` doesn't limit the level of nesting in the JSON schema you created, but there is a practical size limit. Okta recommends a JSON schema size of 1 MB or less for best performance.")
    @JsonProperty(value="profile")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Map<String, Object> profile) {
        this.profile = profile;
    }

    public Application signOnMode(ApplicationSignOnMode signOnMode) {
        this.signOnMode = signOnMode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ApplicationSignOnMode getSignOnMode() {
        return this.signOnMode;
    }

    @JsonProperty(value="signOnMode")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSignOnMode(ApplicationSignOnMode signOnMode) {
        this.signOnMode = signOnMode;
    }

    public Application status(ApplicationLifecycleStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLifecycleStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(ApplicationLifecycleStatus status) {
        this.status = status;
    }

    public Application visibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationVisibility getVisibility() {
        return this.visibility;
    }

    @JsonProperty(value="visibility")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisibility(ApplicationVisibility visibility) {
        this.visibility = visibility;
    }

    public Application embedded(ApplicationEmbedded embedded) {
        this.embedded = embedded;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationEmbedded getEmbedded() {
        return this.embedded;
    }

    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedded(ApplicationEmbedded embedded) {
        this.embedded = embedded;
    }

    public Application links(ApplicationLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(ApplicationLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Application application = (Application)o;
        return Objects.equals(this.accessibility, application.accessibility) && Objects.equals(this.created, application.created) && Objects.equals(this.features, application.features) && Objects.equals(this.id, application.id) && Objects.equals(this.label, application.label) && Objects.equals(this.lastUpdated, application.lastUpdated) && Objects.equals(this.licensing, application.licensing) && Objects.equals(this.orn, application.orn) && Objects.equals(this.profile, application.profile) && Objects.equals((Object)this.signOnMode, (Object)application.signOnMode) && Objects.equals((Object)this.status, (Object)application.status) && Objects.equals(this.visibility, application.visibility) && Objects.equals(this.embedded, application.embedded) && Objects.equals(this.links, application.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessibility, this.created, this.features, this.id, this.label, this.lastUpdated, this.licensing, this.orn, this.profile, this.signOnMode, this.status, this.visibility, this.embedded, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Application {\n");
        sb.append("    accessibility: ").append(this.toIndentedString(this.accessibility)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    features: ").append(this.toIndentedString(this.features)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    licensing: ").append(this.toIndentedString(this.licensing)).append("\n");
        sb.append("    orn: ").append(this.toIndentedString(this.orn)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    signOnMode: ").append(this.toIndentedString((Object)this.signOnMode)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    visibility: ").append(this.toIndentedString(this.visibility)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FeaturesEnum {
        GROUP_PUSH(String.valueOf("GROUP_PUSH")),
        IMPORT_NEW_USERS(String.valueOf("IMPORT_NEW_USERS")),
        IMPORT_PROFILE_UPDATES(String.valueOf("IMPORT_PROFILE_UPDATES")),
        IMPORT_USER_SCHEMA(String.valueOf("IMPORT_USER_SCHEMA")),
        PROFILE_MASTERING(String.valueOf("PROFILE_MASTERING")),
        PUSH_NEW_USERS(String.valueOf("PUSH_NEW_USERS")),
        PUSH_PASSWORD_UPDATES(String.valueOf("PUSH_PASSWORD_UPDATES")),
        PUSH_PROFILE_UPDATES(String.valueOf("PUSH_PROFILE_UPDATES")),
        PUSH_USER_DEACTIVATION(String.valueOf("PUSH_USER_DEACTIVATION")),
        REACTIVATE_USERS(String.valueOf("REACTIVATE_USERS")),
        OUTBOUND_DEL_AUTH(String.valueOf("OUTBOUND_DEL_AUTH")),
        DESKTOP_SSO(String.valueOf("DESKTOP_SSO")),
        FEDERATED_PROFILE(String.valueOf("FEDERATED_PROFILE")),
        SUPPRESS_ACTIVATION_EMAIL(String.valueOf("SUPPRESS_ACTIVATION_EMAIL")),
        PUSH_PENDING_USERS(String.valueOf("PUSH_PENDING_USERS")),
        MFA(String.valueOf("MFA")),
        UPDATE_EXISTING_USERNAME(String.valueOf("UPDATE_EXISTING_USERNAME")),
        EXCLUDE_USERNAME_UPDATE_ON_PROFILE_PUSH(String.valueOf("EXCLUDE_USERNAME_UPDATE_ON_PROFILE_PUSH")),
        EXCHANGE_ACTIVE_SYNC(String.valueOf("EXCHANGE_ACTIVE_SYNC")),
        IMPORT_SYNC(String.valueOf("IMPORT_SYNC")),
        IMPORT_SYNC_CONTACTS(String.valueOf("IMPORT_SYNC_CONTACTS")),
        DEVICE_COMPLIANCE(String.valueOf("DEVICE_COMPLIANCE")),
        VPN_CONFIG(String.valueOf("VPN_CONFIG")),
        IMPORT_SCHEMA_ENUM_VALUES(String.valueOf("IMPORT_SCHEMA_ENUM_VALUES")),
        SCIM_PROVISIONING(String.valueOf("SCIM_PROVISIONING")),
        DEVICE_FILTER_IN_SIGN_ON_RULES(String.valueOf("DEVICE_FILTER_IN_SIGN_ON_RULES")),
        PROFILE_TEMPLATE_UPGRADE(String.valueOf("PROFILE_TEMPLATE_UPGRADE")),
        DEFAULT_PUSH_STATUS_TO_PUSH(String.valueOf("DEFAULT_PUSH_STATUS_TO_PUSH")),
        REAL_TIME_SYNC(String.valueOf("REAL_TIME_SYNC")),
        SSO(String.valueOf("SSO")),
        AUTHN_CONTEXT(String.valueOf("AUTHN_CONTEXT")),
        JIT_PROVISIONING(String.valueOf("JIT_PROVISIONING")),
        GROUP_SYNC(String.valueOf("GROUP_SYNC")),
        OPP_SCIM_INCREMENTAL_IMPORTS(String.valueOf("OPP_SCIM_INCREMENTAL_IMPORTS")),
        IN_MEMORY_APP_USER(String.valueOf("IN_MEMORY_APP_USER")),
        LOG_STREAMING(String.valueOf("LOG_STREAMING")),
        OAUTH_INTEGRATION(String.valueOf("OAUTH_INTEGRATION")),
        IDP(String.valueOf("IDP")),
        PUSH_NEW_USERS_WITHOUT_PASSWORD(String.valueOf("PUSH_NEW_USERS_WITHOUT_PASSWORD")),
        SKYHOOK_SERVICE(String.valueOf("SKYHOOK_SERVICE")),
        ENTITLEMENT_MANAGEMENT(String.valueOf("ENTITLEMENT_MANAGEMENT")),
        PUSH_NEW_USERS_WITH_HASHED_PASSWORD(String.valueOf("PUSH_NEW_USERS_WITH_HASHED_PASSWORD")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private FeaturesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FeaturesEnum fromValue(String value) {
            for (FeaturesEnum b : FeaturesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

