/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.PolicyAccountLink;
import com.okta.sdk.resource.model.PolicySubject;
import com.okta.sdk.resource.model.Provisioning;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Policy settings for the IdP.  The following provisioning and account linking actions are supported by each IdP provider: | IdP type                                                          | User provisioning actions | Group provisioning actions            | Account link actions | Account link filters | | ----------------------------------------------------------------- | ------------------------- | ------------------------------------- | -------------------- | -------------------- | | `SAML2`                                                           | `AUTO` or `DISABLED`      | `NONE`, `ASSIGN`, `APPEND`, or `SYNC` | `AUTO`, `DISABLED`   | `groups`             | | `X509`                                                            | `DISABLED`                | No support for JIT provisioning       |                      |                      | | All social IdP types (any IdP type that isn't `SAML2` or `X509`)  | `AUTO`, `DISABLED`        | `NONE` or `ASSIGN`                    | `AUTO`, `DISABLED`   | `groups`             |")
@JsonPropertyOrder(value={"accountLink", "maxClockSkew", "provisioning", "subject"})
public class IdentityProviderPolicy
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCOUNT_LINK = "accountLink";
    private PolicyAccountLink accountLink;
    public static final String JSON_PROPERTY_MAX_CLOCK_SKEW = "maxClockSkew";
    private Integer maxClockSkew;
    public static final String JSON_PROPERTY_PROVISIONING = "provisioning";
    private Provisioning provisioning;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private PolicySubject subject;

    public IdentityProviderPolicy accountLink(PolicyAccountLink accountLink) {
        this.accountLink = accountLink;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="accountLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicyAccountLink getAccountLink() {
        return this.accountLink;
    }

    @JsonProperty(value="accountLink")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountLink(PolicyAccountLink accountLink) {
        this.accountLink = accountLink;
    }

    public IdentityProviderPolicy maxClockSkew(Integer maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="120000", value="Maximum allowable clock skew when processing messages from the IdP")
    @JsonProperty(value="maxClockSkew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @JsonProperty(value="maxClockSkew")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMaxClockSkew(Integer maxClockSkew) {
        this.maxClockSkew = maxClockSkew;
    }

    public IdentityProviderPolicy provisioning(Provisioning provisioning) {
        this.provisioning = provisioning;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provisioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Provisioning getProvisioning() {
        return this.provisioning;
    }

    @JsonProperty(value="provisioning")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvisioning(Provisioning provisioning) {
        this.provisioning = provisioning;
    }

    public IdentityProviderPolicy subject(PolicySubject subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicySubject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(PolicySubject subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentityProviderPolicy identityProviderPolicy = (IdentityProviderPolicy)o;
        return Objects.equals(this.accountLink, identityProviderPolicy.accountLink) && Objects.equals(this.maxClockSkew, identityProviderPolicy.maxClockSkew) && Objects.equals(this.provisioning, identityProviderPolicy.provisioning) && Objects.equals(this.subject, identityProviderPolicy.subject);
    }

    public int hashCode() {
        return Objects.hash(this.accountLink, this.maxClockSkew, this.provisioning, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IdentityProviderPolicy {\n");
        sb.append("    accountLink: ").append(this.toIndentedString(this.accountLink)).append("\n");
        sb.append("    maxClockSkew: ").append(this.toIndentedString(this.maxClockSkew)).append("\n");
        sb.append("    provisioning: ").append(this.toIndentedString(this.provisioning)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

