/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.AuthenticationMethodObject;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authenticationMethods", "excludedAuthenticationMethods", "methods", "reauthenticateIn", "required", "types"})
public class KnowledgeConstraint
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHENTICATION_METHODS = "authenticationMethods";
    private List<AuthenticationMethodObject> authenticationMethods = null;
    public static final String JSON_PROPERTY_EXCLUDED_AUTHENTICATION_METHODS = "excludedAuthenticationMethods";
    private List<AuthenticationMethodObject> excludedAuthenticationMethods = null;
    public static final String JSON_PROPERTY_METHODS = "methods";
    private List<MethodsEnum> methods = null;
    public static final String JSON_PROPERTY_REAUTHENTICATE_IN = "reauthenticateIn";
    private String reauthenticateIn;
    public static final String JSON_PROPERTY_REQUIRED = "required";
    private Boolean required;
    public static final String JSON_PROPERTY_TYPES = "types";
    private List<TypesEnum> types = null;

    public KnowledgeConstraint authenticationMethods(List<AuthenticationMethodObject> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
        return this;
    }

    public KnowledgeConstraint addauthenticationMethodsItem(AuthenticationMethodObject authenticationMethodsItem) {
        if (this.authenticationMethods == null) {
            this.authenticationMethods = new ArrayList<AuthenticationMethodObject>();
        }
        this.authenticationMethods.add(authenticationMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property specifies the precise authenticator and method for authentication. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(value="authenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticationMethodObject> getAuthenticationMethods() {
        return this.authenticationMethods;
    }

    @JsonProperty(value="authenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthenticationMethods(List<AuthenticationMethodObject> authenticationMethods) {
        this.authenticationMethods = authenticationMethods;
    }

    public KnowledgeConstraint excludedAuthenticationMethods(List<AuthenticationMethodObject> excludedAuthenticationMethods) {
        this.excludedAuthenticationMethods = excludedAuthenticationMethods;
        return this;
    }

    public KnowledgeConstraint addexcludedAuthenticationMethodsItem(AuthenticationMethodObject excludedAuthenticationMethodsItem) {
        if (this.excludedAuthenticationMethods == null) {
            this.excludedAuthenticationMethods = new ArrayList<AuthenticationMethodObject>();
        }
        this.excludedAuthenticationMethods.add(excludedAuthenticationMethodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property specifies the precise authenticator and method to exclude from authentication. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(value="excludedAuthenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<AuthenticationMethodObject> getExcludedAuthenticationMethods() {
        return this.excludedAuthenticationMethods;
    }

    @JsonProperty(value="excludedAuthenticationMethods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludedAuthenticationMethods(List<AuthenticationMethodObject> excludedAuthenticationMethods) {
        this.excludedAuthenticationMethods = excludedAuthenticationMethods;
    }

    public KnowledgeConstraint methods(List<MethodsEnum> methods) {
        this.methods = methods;
        return this;
    }

    public KnowledgeConstraint addmethodsItem(MethodsEnum methodsItem) {
        if (this.methods == null) {
            this.methods = new ArrayList<MethodsEnum>();
        }
        this.methods.add(methodsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Authenticator methods that are permitted")
    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<MethodsEnum> getMethods() {
        return this.methods;
    }

    @JsonProperty(value="methods")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMethods(List<MethodsEnum> methods) {
        this.methods = methods;
    }

    public KnowledgeConstraint reauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The duration after which the user must re-authenticate regardless of user activity. This re-authentication interval overrides the Verification Method object's `reauthenticateIn` interval. The supported values use ISO 8601 period format for recurring time intervals (for example, `PT1H`).")
    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReauthenticateIn() {
        return this.reauthenticateIn;
    }

    @JsonProperty(value="reauthenticateIn")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReauthenticateIn(String reauthenticateIn) {
        this.reauthenticateIn = reauthenticateIn;
    }

    public KnowledgeConstraint required(Boolean required) {
        this.required = required;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="This property indicates whether the knowledge or possession factor is required by the assurance. It's optional in the request, but is always returned in the response. By default, this field is `true`. If the knowledge or possession constraint has values for `excludedAuthenticationMethods` the `required` value is false. <x-lifecycle class=\"oie\"></x-lifecycle>")
    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequired() {
        return this.required;
    }

    @JsonProperty(value="required")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequired(Boolean required) {
        this.required = required;
    }

    public KnowledgeConstraint types(List<TypesEnum> types) {
        this.types = types;
        return this;
    }

    public KnowledgeConstraint addtypesItem(TypesEnum typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<TypesEnum>();
        }
        this.types.add(typesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Authenticator types that are permitted")
    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TypesEnum> getTypes() {
        return this.types;
    }

    @JsonProperty(value="types")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTypes(List<TypesEnum> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KnowledgeConstraint knowledgeConstraint = (KnowledgeConstraint)o;
        return Objects.equals(this.authenticationMethods, knowledgeConstraint.authenticationMethods) && Objects.equals(this.excludedAuthenticationMethods, knowledgeConstraint.excludedAuthenticationMethods) && Objects.equals(this.methods, knowledgeConstraint.methods) && Objects.equals(this.reauthenticateIn, knowledgeConstraint.reauthenticateIn) && Objects.equals(this.required, knowledgeConstraint.required) && Objects.equals(this.types, knowledgeConstraint.types);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationMethods, this.excludedAuthenticationMethods, this.methods, this.reauthenticateIn, this.required, this.types);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KnowledgeConstraint {\n");
        sb.append("    authenticationMethods: ").append(this.toIndentedString(this.authenticationMethods)).append("\n");
        sb.append("    excludedAuthenticationMethods: ").append(this.toIndentedString(this.excludedAuthenticationMethods)).append("\n");
        sb.append("    methods: ").append(this.toIndentedString(this.methods)).append("\n");
        sb.append("    reauthenticateIn: ").append(this.toIndentedString(this.reauthenticateIn)).append("\n");
        sb.append("    required: ").append(this.toIndentedString(this.required)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypesEnum {
        SECURITY_KEY(String.valueOf("SECURITY_KEY")),
        PHONE(String.valueOf("PHONE")),
        EMAIL(String.valueOf("EMAIL")),
        PASSWORD(String.valueOf("PASSWORD")),
        SECURITY_QUESTION(String.valueOf("SECURITY_QUESTION")),
        APP(String.valueOf("APP")),
        FEDERATED(String.valueOf("FEDERATED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypesEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypesEnum fromValue(String value) {
            for (TypesEnum b : TypesEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum MethodsEnum {
        PASSWORD(String.valueOf("PASSWORD")),
        SECURITY_QUESTION(String.valueOf("SECURITY_QUESTION")),
        SMS(String.valueOf("SMS")),
        VOICE(String.valueOf("VOICE")),
        EMAIL(String.valueOf("EMAIL")),
        PUSH(String.valueOf("PUSH")),
        SIGNED_NONCE(String.valueOf("SIGNED_NONCE")),
        OTP(String.valueOf("OTP")),
        TOTP(String.valueOf("TOTP")),
        WEBAUTHN(String.valueOf("WEBAUTHN")),
        DUO(String.valueOf("DUO")),
        IDP(String.valueOf("IDP")),
        CERT(String.valueOf("CERT")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private MethodsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MethodsEnum fromValue(String value) {
            for (MethodsEnum b : MethodsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

