/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.OSVersionDynamicVersionRequirement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies the OS requirement for the policy.  There are two types of OS requirements:  * **Static**: A specific OS version requirement that doesn't change until you update the policy. A static OS requirement is specified with the `osVersion.minimum` property. * **Dynamic**: An OS version requirement that is relative to the latest major OS release and security patch. A dynamic OS requirement is specified with the `osVersion.dynamicVersionRequirement` property. > **Note:** Dynamic OS requirements are available only if the **Dynamic OS version compliance** [self-service EA](/openapi/okta-management/guides/release-lifecycle/#early-access-ea) feature is enabled. You can't specify both `osVersion.minimum` and `osVersion.dynamicVersionRequirement` properties at the same time. ")
@JsonPropertyOrder(value={"dynamicVersionRequirement", "minimum"})
public class OSVersion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DYNAMIC_VERSION_REQUIREMENT = "dynamicVersionRequirement";
    private OSVersionDynamicVersionRequirement dynamicVersionRequirement;
    public static final String JSON_PROPERTY_MINIMUM = "minimum";
    private String minimum;

    public OSVersion dynamicVersionRequirement(OSVersionDynamicVersionRequirement dynamicVersionRequirement) {
        this.dynamicVersionRequirement = dynamicVersionRequirement;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="dynamicVersionRequirement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OSVersionDynamicVersionRequirement getDynamicVersionRequirement() {
        return this.dynamicVersionRequirement;
    }

    @JsonProperty(value="dynamicVersionRequirement")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDynamicVersionRequirement(OSVersionDynamicVersionRequirement dynamicVersionRequirement) {
        this.dynamicVersionRequirement = dynamicVersionRequirement;
    }

    public OSVersion minimum(String minimum) {
        this.minimum = minimum;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="12.4.5", value="The device version must be equal to or newer than the specified version string (maximum of three components for iOS and macOS, and maximum of four components for Android)")
    @JsonProperty(value="minimum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMinimum() {
        return this.minimum;
    }

    @JsonProperty(value="minimum")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSVersion osVersion = (OSVersion)o;
        return Objects.equals(this.dynamicVersionRequirement, osVersion.dynamicVersionRequirement) && Objects.equals(this.minimum, osVersion.minimum);
    }

    public int hashCode() {
        return Objects.hash(this.dynamicVersionRequirement, this.minimum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OSVersion {\n");
        sb.append("    dynamicVersionRequirement: ").append(this.toIndentedString(this.dynamicVersionRequirement)).append("\n");
        sb.append("    minimum: ").append(this.toIndentedString(this.minimum)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

