/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Profile for any Group that is not imported from Active Directory. Specifies the standard and custom profile properties for a Group.  The `objectClass` for these groups is `okta:user_group`.")
@JsonPropertyOrder(value={"description", "name"})
public class OktaUserGroupProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public OktaUserGroupProfile description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="All Users West of The Rockies", value="Description of the Group")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public OktaUserGroupProfile name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="West Coast Users", value="Name of the Group")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OktaUserGroupProfile oktaUserGroupProfile = (OktaUserGroupProfile)o;
        return Objects.equals(this.description, oktaUserGroupProfile.description) && Objects.equals(this.name, oktaUserGroupProfile.name);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OktaUserGroupProfile {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

