/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Specifies the profile attributes for the first super admin user. The minimal set of required attributes are `email`, `firstName`, `lastName`, and `login`. See [profile](/openapi/okta-management/management/tag/User/#tag/User/operation/getUser!c=200&path=profile&t=response) for additional profile attributes.")
@JsonPropertyOrder(value={"firstName", "lastName", "email", "login"})
@JsonTypeName(value="OrgCreationAdmin_profile")
public class OrgCreationAdminProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, Object> additionalProperties = new LinkedHashMap<String, Object>();
    public static final String JSON_PROPERTY_FIRST_NAME = "firstName";
    private String firstName;
    public static final String JSON_PROPERTY_LAST_NAME = "lastName";
    private String lastName;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_LOGIN = "login";
    private String login;

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public OrgCreationAdminProfile firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="Given name of the User (`givenName`)")
    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="firstName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public OrgCreationAdminProfile lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The family name of the User (`familyName`)")
    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="lastName")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public OrgCreationAdminProfile email(String email) {
        this.email = email;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The primary email address of the User. For validation, see [RFC 5322 Section 3.2.3](https://datatracker.ietf.org/doc/html/rfc5322#section-3.2.3).")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEmail(String email) {
        this.email = email;
    }

    public OrgCreationAdminProfile login(String login) {
        this.login = login;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The unique identifier for the User (`username`)")
    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getLogin() {
        return this.login;
    }

    @JsonProperty(value="login")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setLogin(String login) {
        this.login = login;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrgCreationAdminProfile orgCreationAdminProfile = (OrgCreationAdminProfile)o;
        return Objects.equals(this.firstName, orgCreationAdminProfile.firstName) && Objects.equals(this.lastName, orgCreationAdminProfile.lastName) && Objects.equals(this.email, orgCreationAdminProfile.email) && Objects.equals(this.login, orgCreationAdminProfile.login);
    }

    public int hashCode() {
        return Objects.hash(this.firstName, this.lastName, this.email, this.login, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrgCreationAdminProfile {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

