/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "value"})
@JsonTypeName(value="RegistrationResponse_commands_inner")
public class RegistrationResponseCommandsInner
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_VALUE = "value";
    private Map<String, Object> value = null;

    public RegistrationResponseCommandsInner type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location where you specify the command. To set attributes in the user's Okta profile, supply a `type` property set to `com.okta.user.profile.update`, together with a `value` property set to a list of key-value pairs corresponding to the Okta user profile attributes you want to set. The attributes must already exist in your user profile schema.  To explicitly allow or deny registration to the user, supply a type property set to `com.okta.action.update`, together with a value property set to `{\"registration\": \"ALLOW\"}` or `{\"registration\": \"DENY\"}`. The default is to allow registration.  In Okta Identity Engine, to set attributes in the user's profile, supply a `type` property set to `com.okta.user.progressive.profile.update`, together with a `value` property set to a list of key-value pairs corresponding to the Progressive Enrollment attributes that you want to set. See [Registration inline hook - Send response](https://developer.okta.com/docs/guides/registration-inline-hook/nodejs/main/#send-response).  Commands are applied in the order that they appear in the array. Within a single `com.okta.user.profile.update` or `com.okta.user.progressive.profile.update command`, attributes are updated in the order that they appear in the `value` object.  You can never use a command to update the user's password, but you are allowed to set the values of attributes other than password that are designated sensitive in your Okta user schema. However, the values of those sensitive attributes, if included as fields in the Profile Enrollment form, aren't included in the `data.userProfile` object sent to your external service by Okta. See [data.userProfile](/openapi/okta-management/management/tag/InlineHook/#tag/InlineHook/operation/create-registration-hook!path=0/data/userProfile&t=request).")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(String type) {
        this.type = type;
    }

    public RegistrationResponseCommandsInner value(Map<String, Object> value) {
        this.value = value;
        return this;
    }

    public RegistrationResponseCommandsInner putvalueItem(String key, Object valueItem) {
        if (this.value == null) {
            this.value = new HashMap<String, Object>();
        }
        this.value.put(key, valueItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The `value` object is the parameter to pass to the command.  For `com.okta.user.profile.update` commands, `value` should be an object containing one or more name-value pairs for the attributes you wish to update.  For `com.okta.action.update` commands, the value should be an object containing the attribute `action` set to a value of either `ALLOW` or `DENY`, indicating whether the registration should be permitted or not.  Registrations are allowed by default, so setting a value of `ALLOW` for the action field is valid but superfluous.")
    @JsonProperty(value="value")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(content=JsonInclude.Include.ALWAYS, value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(Map<String, Object> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistrationResponseCommandsInner registrationResponseCommandsInner = (RegistrationResponseCommandsInner)o;
        return Objects.equals(this.type, registrationResponseCommandsInner.type) && Objects.equals(this.value, registrationResponseCommandsInner.value);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RegistrationResponseCommandsInner {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

