/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SamlNameIdFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Advanced settings for the SAML 2.0 protocol")
@JsonPropertyOrder(value={"honorPersistentNameId", "nameFormat"})
public class SamlSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_HONOR_PERSISTENT_NAME_ID = "honorPersistentNameId";
    private Boolean honorPersistentNameId = true;
    public static final String JSON_PROPERTY_NAME_FORMAT = "nameFormat";
    private SamlNameIdFormat nameFormat = SamlNameIdFormat.URN_OASIS_NAMES_TC_SAML_1_1_NAMEID_FORMAT_UNSPECIFIED;

    public SamlSettings honorPersistentNameId(Boolean honorPersistentNameId) {
        this.honorPersistentNameId = honorPersistentNameId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines if the IdP should persist account linking when the incoming assertion NameID format is `urn:oasis:names:tc:SAML:2.0:nameid-format:persistent`")
    @JsonProperty(value="honorPersistentNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getHonorPersistentNameId() {
        return this.honorPersistentNameId;
    }

    @JsonProperty(value="honorPersistentNameId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHonorPersistentNameId(Boolean honorPersistentNameId) {
        this.honorPersistentNameId = honorPersistentNameId;
    }

    public SamlSettings nameFormat(SamlNameIdFormat nameFormat) {
        this.nameFormat = nameFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="nameFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SamlNameIdFormat getNameFormat() {
        return this.nameFormat;
    }

    @JsonProperty(value="nameFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNameFormat(SamlNameIdFormat nameFormat) {
        this.nameFormat = nameFormat;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlSettings samlSettings = (SamlSettings)o;
        return Objects.equals(this.honorPersistentNameId, samlSettings.honorPersistentNameId) && Objects.equals((Object)this.nameFormat, (Object)samlSettings.nameFormat);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.honorPersistentNameId, this.nameFormat});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSettings {\n");
        sb.append("    honorPersistentNameId: ").append(this.toIndentedString(this.honorPersistentNameId)).append("\n");
        sb.append("    nameFormat: ").append(this.toIndentedString((Object)this.nameFormat)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

