/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Message profile specifies information about the telephony (sms/voice) message to be sent to the Okta user")
@JsonPropertyOrder(value={"msgTemplate", "phoneNumber", "otpExpires", "deliveryChannel", "otpCode", "locale"})
@JsonTypeName(value="TelephonyRequestData_messageProfile")
public class TelephonyRequestDataMessageProfile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_MSG_TEMPLATE = "msgTemplate";
    private String msgTemplate;
    public static final String JSON_PROPERTY_PHONE_NUMBER = "phoneNumber";
    private String phoneNumber;
    public static final String JSON_PROPERTY_OTP_EXPIRES = "otpExpires";
    private String otpExpires;
    public static final String JSON_PROPERTY_DELIVERY_CHANNEL = "deliveryChannel";
    private String deliveryChannel;
    public static final String JSON_PROPERTY_OTP_CODE = "otpCode";
    private String otpCode;
    public static final String JSON_PROPERTY_LOCALE = "locale";
    private String locale;

    public TelephonyRequestDataMessageProfile msgTemplate(String msgTemplate) {
        this.msgTemplate = msgTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Default or Okta org configured sms or voice message template")
    @JsonProperty(value="msgTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMsgTemplate() {
        return this.msgTemplate;
    }

    @JsonProperty(value="msgTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMsgTemplate(String msgTemplate) {
        this.msgTemplate = msgTemplate;
    }

    public TelephonyRequestDataMessageProfile phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Okta's user's phone number")
    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonProperty(value="phoneNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public TelephonyRequestDataMessageProfile otpExpires(String otpExpires) {
        this.otpExpires = otpExpires;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when OTP expires")
    @JsonProperty(value="otpExpires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOtpExpires() {
        return this.otpExpires;
    }

    @JsonProperty(value="otpExpires")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtpExpires(String otpExpires) {
        this.otpExpires = otpExpires;
    }

    public TelephonyRequestDataMessageProfile deliveryChannel(String deliveryChannel) {
        this.deliveryChannel = deliveryChannel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The channel for OTP delivery - SMS or voice")
    @JsonProperty(value="deliveryChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeliveryChannel() {
        return this.deliveryChannel;
    }

    @JsonProperty(value="deliveryChannel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliveryChannel(String deliveryChannel) {
        this.deliveryChannel = deliveryChannel;
    }

    public TelephonyRequestDataMessageProfile otpCode(String otpCode) {
        this.otpCode = otpCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The OTP code requested by the Okta user")
    @JsonProperty(value="otpCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getOtpCode() {
        return this.otpCode;
    }

    @JsonProperty(value="otpCode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOtpCode(String otpCode) {
        this.otpCode = otpCode;
    }

    public TelephonyRequestDataMessageProfile locale(String locale) {
        this.locale = locale;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The locale associated with the Okta user")
    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getLocale() {
        return this.locale;
    }

    @JsonProperty(value="locale")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocale(String locale) {
        this.locale = locale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TelephonyRequestDataMessageProfile telephonyRequestDataMessageProfile = (TelephonyRequestDataMessageProfile)o;
        return Objects.equals(this.msgTemplate, telephonyRequestDataMessageProfile.msgTemplate) && Objects.equals(this.phoneNumber, telephonyRequestDataMessageProfile.phoneNumber) && Objects.equals(this.otpExpires, telephonyRequestDataMessageProfile.otpExpires) && Objects.equals(this.deliveryChannel, telephonyRequestDataMessageProfile.deliveryChannel) && Objects.equals(this.otpCode, telephonyRequestDataMessageProfile.otpCode) && Objects.equals(this.locale, telephonyRequestDataMessageProfile.locale);
    }

    public int hashCode() {
        return Objects.hash(this.msgTemplate, this.phoneNumber, this.otpExpires, this.deliveryChannel, this.otpCode, this.locale);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TelephonyRequestDataMessageProfile {\n");
        sb.append("    msgTemplate: ").append(this.toIndentedString(this.msgTemplate)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    otpExpires: ").append(this.toIndentedString(this.otpExpires)).append("\n");
        sb.append("    deliveryChannel: ").append(this.toIndentedString(this.deliveryChannel)).append("\n");
        sb.append("    otpCode: ").append(this.toIndentedString(this.otpCode)).append("\n");
        sb.append("    locale: ").append(this.toIndentedString(this.locale)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

