/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="An account on a test instance of your app with admin privileges. A test admin account is required by Okta for integration testing. During OIN QA testing, an Okta analyst uses this admin account to configure your app for the various test case flows.")
@JsonPropertyOrder(value={"url", "username", "password", "instructions"})
@JsonTypeName(value="TestInfo_testAccount")
public class TestInfoTestAccount
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_URL = "url";
    private URI url;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password;
    public static final String JSON_PROPERTY_INSTRUCTIONS = "instructions";
    private String instructions;

    public TestInfoTestAccount url(URI url) {
        this.url = url;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.com/strawberry/login", required=true, value="The sign-in URL to a test instance of your app")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public URI getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUrl(URI url) {
        this.url = url;
    }

    public TestInfoTestAccount username(String username) {
        this.username = username;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="test@example.com", required=true, value="The username for your app admin account")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setUsername(String username) {
        this.username = username;
    }

    public TestInfoTestAccount password(String password) {
        this.password = password;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="sUperP@ssw0rd", required=true, value="The password for your app admin account")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPassword(String password) {
        this.password = password;
    }

    public TestInfoTestAccount instructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="Go to your app URL from a browser and enter your credentials", value="Additional instructions to test the app integration, including instructions for obtaining test accounts")
    @JsonProperty(value="instructions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInstructions() {
        return this.instructions;
    }

    @JsonProperty(value="instructions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInstructions(String instructions) {
        this.instructions = instructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestInfoTestAccount testInfoTestAccount = (TestInfoTestAccount)o;
        return Objects.equals(this.url, testInfoTestAccount.url) && Objects.equals(this.username, testInfoTestAccount.username) && Objects.equals(this.password, testInfoTestAccount.password) && Objects.equals(this.instructions, testInfoTestAccount.instructions);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.username, this.password, this.instructions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfoTestAccount {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    instructions: ").append(this.toIndentedString(this.instructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

