/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Describes how the account is blocked from access. If `appliesTo` is `ANY_DEVICES`, then the account is blocked for all devices. If `appliesTo` is `UNKNOWN_DEVICES`, then the account is only blocked for unknown devices.")
@JsonPropertyOrder(value={"appliesTo", "type"})
public class UserBlock
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APPLIES_TO = "appliesTo";
    private AppliesToEnum appliesTo;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    @Nullable
    @ApiModelProperty(value="The devices that the block applies to")
    @JsonProperty(value="appliesTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppliesToEnum getAppliesTo() {
        return this.appliesTo;
    }

    @Nullable
    @ApiModelProperty(value="Type of access block")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserBlock userBlock = (UserBlock)o;
        return Objects.equals((Object)this.appliesTo, (Object)userBlock.appliesTo) && Objects.equals((Object)this.type, (Object)userBlock.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appliesTo, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserBlock {\n");
        sb.append("    appliesTo: ").append(this.toIndentedString((Object)this.appliesTo)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AppliesToEnum {
        ANY_DEVICES(String.valueOf("ANY_DEVICES")),
        UNKNOWN_DEVICES(String.valueOf("UNKNOWN_DEVICES")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private AppliesToEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AppliesToEnum fromValue(String value) {
            for (AppliesToEnum b : AppliesToEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum TypeEnum {
        DEVICE_BASED(String.valueOf("DEVICE_BASED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

