/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.okta.sdk.resource.model.UserFactorCall;
import com.okta.sdk.resource.model.UserFactorEmail;
import com.okta.sdk.resource.model.UserFactorLinks;
import com.okta.sdk.resource.model.UserFactorProvider;
import com.okta.sdk.resource.model.UserFactorPush;
import com.okta.sdk.resource.model.UserFactorSMS;
import com.okta.sdk.resource.model.UserFactorSecurityQuestion;
import com.okta.sdk.resource.model.UserFactorStatus;
import com.okta.sdk.resource.model.UserFactorToken;
import com.okta.sdk.resource.model.UserFactorTokenHOTP;
import com.okta.sdk.resource.model.UserFactorTokenHardware;
import com.okta.sdk.resource.model.UserFactorTokenSoftwareTOTP;
import com.okta.sdk.resource.model.UserFactorType;
import com.okta.sdk.resource.model.UserFactorU2F;
import com.okta.sdk.resource.model.UserFactorWeb;
import com.okta.sdk.resource.model.UserFactorWebAuthn;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "factorType", "id", "lastUpdated", "profile", "provider", "status", "vendorName", "_embedded", "_links"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="factorType", visible=true, defaultImpl=UserFactor.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=UserFactorCall.class, name="call"), @JsonSubTypes.Type(value=UserFactorEmail.class, name="email"), @JsonSubTypes.Type(value=UserFactorTokenHOTP.class, name="hotp"), @JsonSubTypes.Type(value=UserFactorPush.class, name="push"), @JsonSubTypes.Type(value=UserFactorSecurityQuestion.class, name="question"), @JsonSubTypes.Type(value=UserFactorSMS.class, name="sms"), @JsonSubTypes.Type(value=UserFactorToken.class, name="token"), @JsonSubTypes.Type(value=UserFactorTokenHardware.class, name="token:hardware"), @JsonSubTypes.Type(value=UserFactorTokenHOTP.class, name="token:hotp"), @JsonSubTypes.Type(value=UserFactorTokenSoftwareTOTP.class, name="token:software:totp"), @JsonSubTypes.Type(value=UserFactorU2F.class, name="u2f"), @JsonSubTypes.Type(value=UserFactorWeb.class, name="web"), @JsonSubTypes.Type(value=UserFactorWebAuthn.class, name="webauthn")})
public class UserFactor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_FACTOR_TYPE = "factorType";
    protected UserFactorType factorType;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Object profile;
    public static final String JSON_PROPERTY_PROVIDER = "provider";
    private UserFactorProvider provider;
    public static final String JSON_PROPERTY_STATUS = "status";
    private UserFactorStatus status;
    public static final String JSON_PROPERTY_VENDOR_NAME = "vendorName";
    private String vendorName;
    public static final String JSON_PROPERTY_EMBEDDED = "_embedded";
    private Map<String, Object> embedded = null;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private UserFactorLinks links;

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:31Z", value="Timestamp when the Factor was enrolled")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public UserFactor factorType(UserFactorType factorType) {
        this.factorType = factorType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="factorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorType getFactorType() {
        return this.factorType;
    }

    @JsonProperty(value="factorType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFactorType(UserFactorType factorType) {
        this.factorType = factorType;
    }

    @Nullable
    @ApiModelProperty(example="caf8m6jbcvUH8mAep1d7", value="ID of the Factor")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @Nullable
    @ApiModelProperty(example="2022-08-25T00:31Z", value="Timestamp when the Factor was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public UserFactor profile(Object profile) {
        this.profile = profile;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Specific attributes related to the Factor")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getProfile() {
        return this.profile;
    }

    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProfile(Object profile) {
        this.profile = profile;
    }

    public UserFactor provider(UserFactorProvider provider) {
        this.provider = provider;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorProvider getProvider() {
        return this.provider;
    }

    @JsonProperty(value="provider")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProvider(UserFactorProvider provider) {
        this.provider = provider;
    }

    public UserFactor status(UserFactorStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(UserFactorStatus status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(example="OKTA", value="Name of the Factor vendor. This is usually the same as the provider except for On-Prem MFA where it depends on administrator settings.")
    @JsonProperty(value="vendorName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getVendorName() {
        return this.vendorName;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getEmbedded() {
        return this.embedded;
    }

    public UserFactor links(UserFactorLinks links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserFactorLinks getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(UserFactorLinks links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFactor userFactor = (UserFactor)o;
        return Objects.equals(this.created, userFactor.created) && Objects.equals((Object)this.factorType, (Object)userFactor.factorType) && Objects.equals(this.id, userFactor.id) && Objects.equals(this.lastUpdated, userFactor.lastUpdated) && Objects.equals(this.profile, userFactor.profile) && Objects.equals((Object)this.provider, (Object)userFactor.provider) && Objects.equals((Object)this.status, (Object)userFactor.status) && Objects.equals(this.vendorName, userFactor.vendorName) && Objects.equals(this.embedded, userFactor.embedded) && Objects.equals(this.links, userFactor.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.created, this.factorType, this.id, this.lastUpdated, this.profile, this.provider, this.status, this.vendorName, this.embedded, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserFactor {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    factorType: ").append(this.toIndentedString((Object)this.factorType)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString((Object)this.provider)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    vendorName: ").append(this.toIndentedString(this.vendorName)).append("\n");
        sb.append("    embedded: ").append(this.toIndentedString(this.embedded)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

