/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.api;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.okta.sdk.resource.client.ApiClient;
import com.okta.sdk.resource.client.ApiException;
import com.okta.sdk.resource.client.Configuration;
import com.okta.sdk.resource.client.Pair;
import com.okta.sdk.resource.model.OAuth2Claim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.openapitools.jackson.nullable.JsonNullableModule;

public class AuthorizationServerClaimsApi {
    private ApiClient apiClient;

    public AuthorizationServerClaimsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AuthorizationServerClaimsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim) throws ApiException {
        return this.createOAuth2Claim(authServerId, oAuth2Claim, Collections.emptyMap());
    }

    public OAuth2Claim createOAuth2Claim(String authServerId, OAuth2Claim oAuth2Claim, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling createOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Claim' when calling createOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public void deleteOAuth2Claim(String authServerId, String claimId) throws ApiException {
        this.deleteOAuth2Claim(authServerId, claimId, Collections.emptyMap());
    }

    public void deleteOAuth2Claim(String authServerId, String claimId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling deleteOAuth2Claim");
        }
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling deleteOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{claimId\\}", this.apiClient.escapeString(claimId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        this.apiClient.invokeAPI(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, null);
    }

    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId) throws ApiException {
        return this.getOAuth2Claim(authServerId, claimId, Collections.emptyMap());
    }

    public OAuth2Claim getOAuth2Claim(String authServerId, String claimId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling getOAuth2Claim");
        }
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling getOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{claimId\\}", this.apiClient.escapeString(claimId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public List<OAuth2Claim> listOAuth2Claims(String authServerId) throws ApiException {
        return this.listOAuth2Claims(authServerId, Collections.emptyMap());
    }

    public List<OAuth2Claim> listOAuth2Claims(String authServerId, Map<String, String> additionalHeaders) throws ApiException {
        Object localVarPostBody = null;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling listOAuth2Claims");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<List<OAuth2Claim>> localVarReturnType = new TypeReference<List<OAuth2Claim>>(){};
        return this.apiClient.invokeAPI(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim) throws ApiException {
        return this.replaceOAuth2Claim(authServerId, claimId, oAuth2Claim, Collections.emptyMap());
    }

    public OAuth2Claim replaceOAuth2Claim(String authServerId, String claimId, OAuth2Claim oAuth2Claim, Map<String, String> additionalHeaders) throws ApiException {
        OAuth2Claim localVarPostBody = oAuth2Claim;
        if (authServerId == null) {
            throw new ApiException(400, "Missing the required parameter 'authServerId' when calling replaceOAuth2Claim");
        }
        if (claimId == null) {
            throw new ApiException(400, "Missing the required parameter 'claimId' when calling replaceOAuth2Claim");
        }
        if (oAuth2Claim == null) {
            throw new ApiException(400, "Missing the required parameter 'oAuth2Claim' when calling replaceOAuth2Claim");
        }
        String localVarPath = "/api/v1/authorizationServers/{authServerId}/claims/{claimId}".replaceAll("\\{authServerId\\}", this.apiClient.escapeString(authServerId.toString())).replaceAll("\\{claimId\\}", this.apiClient.escapeString(claimId.toString()));
        StringJoiner localVarQueryStringJoiner = new StringJoiner("&");
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        localVarHeaderParams.putAll(additionalHeaders);
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"apiToken", "oauth2"};
        TypeReference<OAuth2Claim> localVarReturnType = new TypeReference<OAuth2Claim>(){};
        return this.apiClient.invokeAPI(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarQueryStringJoiner.toString(), localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    protected static ObjectMapper getObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonNullableModule());
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        return objectMapper;
    }
}

