/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.AppInstanceContainerStatus;
import com.okta.sdk.resource.model.AppLink;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Container details for resource type APP_ACCOUNT")
@JsonPropertyOrder(value={"appName", "containerId", "displayName", "globalAppId", "passwordPushSupported", "provisioningEnabled", "status", "_links"})
public class AppAccountContainerDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_APP_NAME = "appName";
    private String appName;
    public static final String JSON_PROPERTY_CONTAINER_ID = "containerId";
    private String containerId;
    public static final String JSON_PROPERTY_DISPLAY_NAME = "displayName";
    private String displayName;
    public static final String JSON_PROPERTY_GLOBAL_APP_ID = "globalAppId";
    private String globalAppId;
    public static final String JSON_PROPERTY_PASSWORD_PUSH_SUPPORTED = "passwordPushSupported";
    private Boolean passwordPushSupported;
    public static final String JSON_PROPERTY_PROVISIONING_ENABLED = "provisioningEnabled";
    private Boolean provisioningEnabled;
    public static final String JSON_PROPERTY_STATUS = "status";
    private AppInstanceContainerStatus status;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private AppLink links;

    @Nullable
    @ApiModelProperty(example="google", value="The application name")
    @JsonProperty(value="appName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAppName() {
        return this.appName;
    }

    public AppAccountContainerDetails containerId(String containerId) {
        this.containerId = containerId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="0oa103099SBEb3Z2b0g4", required=true, value="The application ID associated with the privileged account")
    @JsonProperty(value="containerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getContainerId() {
        return this.containerId;
    }

    @JsonProperty(value="containerId")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Nullable
    @ApiModelProperty(example="Google App1", value="Human-readable name of the container that owns the privileged resource")
    @JsonProperty(value="displayName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDisplayName() {
        return this.displayName;
    }

    @Nullable
    @ApiModelProperty(example="964b82aa-85b4-5645-b790-83312c473480", value="The application global ID")
    @JsonProperty(value="globalAppId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGlobalAppId() {
        return this.globalAppId;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates if the application supports password push")
    @JsonProperty(value="passwordPushSupported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getPasswordPushSupported() {
        return this.passwordPushSupported;
    }

    @Nullable
    @ApiModelProperty(example="true", value="Indicates if provisioning is enabled for this application")
    @JsonProperty(value="provisioningEnabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getProvisioningEnabled() {
        return this.provisioningEnabled;
    }

    public AppAccountContainerDetails status(AppInstanceContainerStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppInstanceContainerStatus getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(AppInstanceContainerStatus status) {
        this.status = status;
    }

    public AppAccountContainerDetails links(AppLink links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public AppLink getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(AppLink links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AppAccountContainerDetails appAccountContainerDetails = (AppAccountContainerDetails)o;
        return Objects.equals(this.appName, appAccountContainerDetails.appName) && Objects.equals(this.containerId, appAccountContainerDetails.containerId) && Objects.equals(this.displayName, appAccountContainerDetails.displayName) && Objects.equals(this.globalAppId, appAccountContainerDetails.globalAppId) && Objects.equals(this.passwordPushSupported, appAccountContainerDetails.passwordPushSupported) && Objects.equals(this.provisioningEnabled, appAccountContainerDetails.provisioningEnabled) && Objects.equals((Object)this.status, (Object)appAccountContainerDetails.status) && Objects.equals(this.links, appAccountContainerDetails.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appName, this.containerId, this.displayName, this.globalAppId, this.passwordPushSupported, this.provisioningEnabled, this.status, this.links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AppAccountContainerDetails {\n");
        sb.append("    appName: ").append(this.toIndentedString(this.appName)).append("\n");
        sb.append("    containerId: ").append(this.toIndentedString(this.containerId)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    globalAppId: ").append(this.toIndentedString(this.globalAppId)).append("\n");
        sb.append("    passwordPushSupported: ").append(this.toIndentedString(this.passwordPushSupported)).append("\n");
        sb.append("    provisioningEnabled: ").append(this.toIndentedString(this.provisioningEnabled)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

