/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The template used to generate the username when the app is assigned through a group or directly to a user")
@JsonPropertyOrder(value={"pushStatus", "template", "type", "userSuffix"})
public class ApplicationCredentialsUsernameTemplate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PUSH_STATUS = "pushStatus";
    private PushStatusEnum pushStatus;
    public static final String JSON_PROPERTY_TEMPLATE = "template";
    private String template = "${source.login}";
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type = TypeEnum.BUILT_IN;
    public static final String JSON_PROPERTY_USER_SUFFIX = "userSuffix";
    private String userSuffix;

    public ApplicationCredentialsUsernameTemplate pushStatus(PushStatusEnum pushStatus) {
        this.pushStatus = pushStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Determines if the username is pushed to the app on updates for CUSTOM `type`")
    @JsonProperty(value="pushStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PushStatusEnum getPushStatus() {
        return this.pushStatus;
    }

    @JsonProperty(value="pushStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPushStatus(PushStatusEnum pushStatus) {
        this.pushStatus = pushStatus;
    }

    public ApplicationCredentialsUsernameTemplate template(String template) {
        this.template = template;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Mapping expression used to generate usernames.  The following are supported mapping expressions that are used with the `BUILT_IN` template type:  | Name                            | Template Expression                            | | ------------------------------- | ---------------------------------------------- | | AD Employee ID                  | `${source.employeeID}`                         | | AD SAM Account Name             | `${source.samAccountName}`                     | | AD SAM Account Name (lowercase) | `${fn:toLowerCase(source.samAccountName)}`     | | AD User Principal Name          | `${source.userName}`                           | | AD User Principal Name prefix   | `${fn:substringBefore(source.userName, \"@\")}`  | | Email                           | `${source.email}`                              | | Email (lowercase)               | `${fn:toLowerCase(source.email)}`              | | Email prefix                    | `${fn:substringBefore(source.email, \"@\")}`     | | LDAP UID + custom suffix        | `${source.userName}${instance.userSuffix}`     | | Okta username                   | `${source.login}`                              | | Okta username prefix            | `${fn:substringBefore(source.login, \"@\")}`     |")
    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTemplate() {
        return this.template;
    }

    @JsonProperty(value="template")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplate(String template) {
        this.template = template;
    }

    public ApplicationCredentialsUsernameTemplate type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Type of mapping expression. Empty string is allowed.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public ApplicationCredentialsUsernameTemplate userSuffix(String userSuffix) {
        this.userSuffix = userSuffix;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An optional suffix appended to usernames for `BUILT_IN` mapping expressions")
    @JsonProperty(value="userSuffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserSuffix() {
        return this.userSuffix;
    }

    @JsonProperty(value="userSuffix")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserSuffix(String userSuffix) {
        this.userSuffix = userSuffix;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationCredentialsUsernameTemplate applicationCredentialsUsernameTemplate = (ApplicationCredentialsUsernameTemplate)o;
        return Objects.equals((Object)this.pushStatus, (Object)applicationCredentialsUsernameTemplate.pushStatus) && Objects.equals(this.template, applicationCredentialsUsernameTemplate.template) && Objects.equals((Object)this.type, (Object)applicationCredentialsUsernameTemplate.type) && Objects.equals(this.userSuffix, applicationCredentialsUsernameTemplate.userSuffix);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pushStatus, this.template, this.type, this.userSuffix});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationCredentialsUsernameTemplate {\n");
        sb.append("    pushStatus: ").append(this.toIndentedString((Object)this.pushStatus)).append("\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    userSuffix: ").append(this.toIndentedString(this.userSuffix)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        NONE(String.valueOf("NONE")),
        BUILT_IN(String.valueOf("BUILT_IN")),
        CUSTOM(String.valueOf("CUSTOM")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum PushStatusEnum {
        PUSH(String.valueOf("PUSH")),
        DONT_PUSH(String.valueOf("DONT_PUSH")),
        NOT_CONFIGURED(String.valueOf("NOT_CONFIGURED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private PushStatusEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PushStatusEnum fromValue(String value) {
            for (PushStatusEnum b : PushStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

