/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"hardwareProtection", "id", "key", "method", "phishingResistant", "userVerification"})
public class AuthenticationMethod
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_HARDWARE_PROTECTION = "hardwareProtection";
    private HardwareProtectionEnum hardwareProtection = HardwareProtectionEnum.OPTIONAL;
    public static final String JSON_PROPERTY_ID = "id";
    private String id;
    public static final String JSON_PROPERTY_KEY = "key";
    private String key;
    public static final String JSON_PROPERTY_METHOD = "method";
    private String method;
    public static final String JSON_PROPERTY_PHISHING_RESISTANT = "phishingResistant";
    private PhishingResistantEnum phishingResistant = PhishingResistantEnum.OPTIONAL;
    public static final String JSON_PROPERTY_USER_VERIFICATION = "userVerification";
    private UserVerificationEnum userVerification = UserVerificationEnum.OPTIONAL;

    public AuthenticationMethod hardwareProtection(HardwareProtectionEnum hardwareProtection) {
        this.hardwareProtection = hardwareProtection;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if any secrets or private keys used during authentication must be hardware protected and not exportable. This property is only set for `POSSESSION` constraints.")
    @JsonProperty(value="hardwareProtection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public HardwareProtectionEnum getHardwareProtection() {
        return this.hardwareProtection;
    }

    @JsonProperty(value="hardwareProtection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHardwareProtection(HardwareProtectionEnum hardwareProtection) {
        this.hardwareProtection = hardwareProtection;
    }

    public AuthenticationMethod id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An ID that identifies the authenticator")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(String id) {
        this.id = id;
    }

    public AuthenticationMethod key(String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="A label that identifies the authenticator")
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getKey() {
        return this.key;
    }

    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setKey(String key) {
        this.key = key;
    }

    public AuthenticationMethod method(String method) {
        this.method = method;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Specifies the method used for the authenticator")
    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getMethod() {
        return this.method;
    }

    @JsonProperty(value="method")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMethod(String method) {
        this.method = method;
    }

    public AuthenticationMethod phishingResistant(PhishingResistantEnum phishingResistant) {
        this.phishingResistant = phishingResistant;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if phishing-resistant Factors are required. This property is only set for `POSSESSION` constraints")
    @JsonProperty(value="phishingResistant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhishingResistantEnum getPhishingResistant() {
        return this.phishingResistant;
    }

    @JsonProperty(value="phishingResistant")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhishingResistant(PhishingResistantEnum phishingResistant) {
        this.phishingResistant = phishingResistant;
    }

    public AuthenticationMethod userVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates the user interaction requirement (PIN or biometrics) to ensure verification of a possession factor")
    @JsonProperty(value="userVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public UserVerificationEnum getUserVerification() {
        return this.userVerification;
    }

    @JsonProperty(value="userVerification")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserVerification(UserVerificationEnum userVerification) {
        this.userVerification = userVerification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationMethod authenticationMethod = (AuthenticationMethod)o;
        return Objects.equals((Object)this.hardwareProtection, (Object)authenticationMethod.hardwareProtection) && Objects.equals(this.id, authenticationMethod.id) && Objects.equals(this.key, authenticationMethod.key) && Objects.equals(this.method, authenticationMethod.method) && Objects.equals((Object)this.phishingResistant, (Object)authenticationMethod.phishingResistant) && Objects.equals((Object)this.userVerification, (Object)authenticationMethod.userVerification);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hardwareProtection, this.id, this.key, this.method, this.phishingResistant, this.userVerification});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationMethod {\n");
        sb.append("    hardwareProtection: ").append(this.toIndentedString((Object)this.hardwareProtection)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    phishingResistant: ").append(this.toIndentedString((Object)this.phishingResistant)).append("\n");
        sb.append("    userVerification: ").append(this.toIndentedString((Object)this.userVerification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum HardwareProtectionEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private HardwareProtectionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static HardwareProtectionEnum fromValue(String value) {
            for (HardwareProtectionEnum b : HardwareProtectionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum PhishingResistantEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private PhishingResistantEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhishingResistantEnum fromValue(String value) {
            for (PhishingResistantEnum b : PhishingResistantEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum UserVerificationEnum {
        OPTIONAL(String.valueOf("OPTIONAL")),
        REQUIRED(String.valueOf("REQUIRED")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private UserVerificationEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UserVerificationEnum fromValue(String value) {
            for (UserVerificationEnum b : UserVerificationEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

