/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.LinksSelf;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"alg", "e", "kid", "kty", "n", "status", "use", "_links"})
public class AuthorizationServerJsonWebKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALG = "alg";
    private String alg;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_STATUS = "status";
    private String status;
    public static final String JSON_PROPERTY_USE = "use";
    private String use;
    public static final String JSON_PROPERTY_LINKS = "_links";
    private LinksSelf links;

    public AuthorizationServerJsonWebKey alg(String alg) {
        this.alg = alg;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The algorithm used with the Key. Valid value: `RS256`")
    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAlg() {
        return this.alg;
    }

    @JsonProperty(value="alg")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlg(String alg) {
        this.alg = alg;
    }

    @Nullable
    @ApiModelProperty(value="RSA key value (public exponent) for Key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the key")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @Nullable
    @ApiModelProperty(value="Cryptographic algorithm family for the certificate's keypair. Valid value: `RSA`")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKty() {
        return this.kty;
    }

    public AuthorizationServerJsonWebKey n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RSA modulus value that is used by both the public and private keys and provides a link between them")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    public AuthorizationServerJsonWebKey status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An `ACTIVE` Key is used to sign tokens issued by the authorization server. Supported values: `ACTIVE`, `NEXT`, or `EXPIRED`<br> A `NEXT` Key is the next Key that the authorization server uses to sign tokens when Keys are rotated. The `NEXT` Key might not be listed if it hasn't been generated. An `EXPIRED` Key is the previous Key that the authorization server used to sign tokens. The `EXPIRED` Key might not be listed if no Key has expired or the expired Key was deleted.")
    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStatus() {
        return this.status;
    }

    @JsonProperty(value="status")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStatus(String status) {
        this.status = status;
    }

    @Nullable
    @ApiModelProperty(value="Acceptable use of the key. Valid value: `sig`")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUse() {
        return this.use;
    }

    public AuthorizationServerJsonWebKey links(LinksSelf links) {
        this.links = links;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public LinksSelf getLinks() {
        return this.links;
    }

    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLinks(LinksSelf links) {
        this.links = links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthorizationServerJsonWebKey authorizationServerJsonWebKey = (AuthorizationServerJsonWebKey)o;
        return Objects.equals(this.alg, authorizationServerJsonWebKey.alg) && Objects.equals(this.e, authorizationServerJsonWebKey.e) && Objects.equals(this.kid, authorizationServerJsonWebKey.kid) && Objects.equals(this.kty, authorizationServerJsonWebKey.kty) && Objects.equals(this.n, authorizationServerJsonWebKey.n) && Objects.equals(this.status, authorizationServerJsonWebKey.status) && Objects.equals(this.use, authorizationServerJsonWebKey.use) && Objects.equals(this.links, authorizationServerJsonWebKey.links);
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.e, this.kid, this.kty, this.n, this.status, this.use, this.links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthorizationServerJsonWebKey {\n");
        sb.append("    alg: ").append(this.toIndentedString(this.alg)).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

