/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.Application;
import com.okta.sdk.resource.model.ApplicationCredentials;
import com.okta.sdk.resource.model.BookmarkApplicationSettings;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"credentials", "name", "settings"})
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="signOnMode", visible=true, defaultImpl=BookmarkApplication.class)
public class BookmarkApplication
extends Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private ApplicationCredentials credentials;
    public static final String JSON_PROPERTY_NAME = "name";
    private NameEnum name;
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private BookmarkApplicationSettings settings;

    public BookmarkApplication credentials(ApplicationCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApplicationCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(ApplicationCredentials credentials) {
        this.credentials = credentials;
    }

    public BookmarkApplication name(NameEnum name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="`bookmark` is the key name for a Bookmark app")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public NameEnum getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(NameEnum name) {
        this.name = name;
    }

    public BookmarkApplication settings(BookmarkApplicationSettings settings) {
        this.settings = settings;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BookmarkApplicationSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSettings(BookmarkApplicationSettings settings) {
        this.settings = settings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BookmarkApplication bookmarkApplication = (BookmarkApplication)o;
        return Objects.equals(this.credentials, bookmarkApplication.credentials) && Objects.equals((Object)this.name, (Object)bookmarkApplication.name) && Objects.equals(this.settings, bookmarkApplication.settings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.credentials, this.name, this.settings, super.hashCode()});
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BookmarkApplication {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum NameEnum {
        BOOKMARK(String.valueOf("bookmark")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private NameEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static NameEnum fromValue(String value) {
            for (NameEnum b : NameEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

