/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Google app instance properties")
@JsonPropertyOrder(value={"domain", "rpId"})
public class GoogleApplicationSettingsApplication
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DOMAIN = "domain";
    private String domain;
    public static final String JSON_PROPERTY_RP_ID = "rpId";
    private String rpId;

    public GoogleApplicationSettingsApplication domain(String domain) {
        this.domain = domain;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Your Google company domain")
    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty(value="domain")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDomain(String domain) {
        this.domain = domain;
    }

    public GoogleApplicationSettingsApplication rpId(String rpId) {
        this.rpId = rpId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RPID")
    @JsonProperty(value="rpId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRpId() {
        return this.rpId;
    }

    @JsonProperty(value="rpId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRpId(String rpId) {
        this.rpId = rpId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GoogleApplicationSettingsApplication googleApplicationSettingsApplication = (GoogleApplicationSettingsApplication)o;
        return Objects.equals(this.domain, googleApplicationSettingsApplication.domain) && Objects.equals(this.rpId, googleApplicationSettingsApplication.rpId);
    }

    public int hashCode() {
        return Objects.hash(this.domain, this.rpId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GoogleApplicationSettingsApplication {\n");
        sb.append("    domain: ").append(this.toIndentedString(this.domain)).append("\n");
        sb.append("    rpId: ").append(this.toIndentedString(this.rpId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

