/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"created", "e", "expiresAt", "kid", "kty", "lastUpdated", "n", "use", "x5c", "x5t#S256"})
public class JsonWebKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_CREATED = "created";
    private OffsetDateTime created;
    public static final String JSON_PROPERTY_E = "e";
    private String e;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expiresAt";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_KID = "kid";
    private String kid;
    public static final String JSON_PROPERTY_KTY = "kty";
    private String kty;
    public static final String JSON_PROPERTY_LAST_UPDATED = "lastUpdated";
    private OffsetDateTime lastUpdated;
    public static final String JSON_PROPERTY_N = "n";
    private String n;
    public static final String JSON_PROPERTY_USE = "use";
    private String use;
    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;
    public static final String JSON_PROPERTY_X5T_HASH_S256 = "x5t#S256";
    private String x5tHashS256;

    @Nullable
    @ApiModelProperty(example="2017-03-28T01:11:10Z", value="Timestamp when the object was created")
    @JsonProperty(value="created")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreated() {
        return this.created;
    }

    @Nullable
    @ApiModelProperty(value="RSA key value (public exponent) for Key binding")
    @JsonProperty(value="e")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getE() {
        return this.e;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the certificate expires")
    @JsonProperty(value="expiresAt")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @Nullable
    @ApiModelProperty(value="Unique identifier for the certificate")
    @JsonProperty(value="kid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKid() {
        return this.kid;
    }

    @Nullable
    @ApiModelProperty(value="Cryptographic algorithm family for the certificate's keypair. Valid value: `RSA`")
    @JsonProperty(value="kty")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getKty() {
        return this.kty;
    }

    @Nullable
    @ApiModelProperty(value="Timestamp when the object was last updated")
    @JsonProperty(value="lastUpdated")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLastUpdated() {
        return this.lastUpdated;
    }

    public JsonWebKey n(String n) {
        this.n = n;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="RSA modulus value that is used by both the public and private keys and provides a link between them")
    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getN() {
        return this.n;
    }

    @JsonProperty(value="n")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setN(String n) {
        this.n = n;
    }

    @Nullable
    @ApiModelProperty(value="Acceptable use of the certificate. Valid value: `sig`")
    @JsonProperty(value="use")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUse() {
        return this.use;
    }

    @Nullable
    @ApiModelProperty(value="X.509 certificate chain that contains a chain of one or more certificates")
    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getX5c() {
        return this.x5c;
    }

    @Nullable
    @ApiModelProperty(value="X.509 certificate SHA-256 thumbprint, which is the base64url-encoded SHA-256 thumbprint (digest) of the DER encoding of an X.509 certificate")
    @JsonProperty(value="x5t#S256")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getX5tHashS256() {
        return this.x5tHashS256;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonWebKey jsonWebKey = (JsonWebKey)o;
        return Objects.equals(this.created, jsonWebKey.created) && Objects.equals(this.e, jsonWebKey.e) && Objects.equals(this.expiresAt, jsonWebKey.expiresAt) && Objects.equals(this.kid, jsonWebKey.kid) && Objects.equals(this.kty, jsonWebKey.kty) && Objects.equals(this.lastUpdated, jsonWebKey.lastUpdated) && Objects.equals(this.n, jsonWebKey.n) && Objects.equals(this.use, jsonWebKey.use) && Objects.equals(this.x5c, jsonWebKey.x5c) && Objects.equals(this.x5tHashS256, jsonWebKey.x5tHashS256);
    }

    public int hashCode() {
        return Objects.hash(this.created, this.e, this.expiresAt, this.kid, this.kty, this.lastUpdated, this.n, this.use, this.x5c, this.x5tHashS256);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class JsonWebKey {\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    e: ").append(this.toIndentedString(this.e)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    kid: ").append(this.toIndentedString(this.kid)).append("\n");
        sb.append("    kty: ").append(this.toIndentedString(this.kty)).append("\n");
        sb.append("    lastUpdated: ").append(this.toIndentedString(this.lastUpdated)).append("\n");
        sb.append("    n: ").append(this.toIndentedString(this.n)).append("\n");
        sb.append("    use: ").append(this.toIndentedString(this.use)).append("\n");
        sb.append("    x5c: ").append(this.toIndentedString(this.x5c)).append("\n");
        sb.append("    x5tHashS256: ").append(this.toIndentedString(this.x5tHashS256)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

