/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.CodeChallengeMethod;
import com.okta.sdk.resource.model.EndpointAuthMethod;
import com.okta.sdk.resource.model.GrantType;
import com.okta.sdk.resource.model.ResponseMode;
import com.okta.sdk.resource.model.ResponseTypesSupported;
import com.okta.sdk.resource.model.SigningAlgorithm;
import com.okta.sdk.resource.model.SubjectType;
import com.okta.sdk.resource.model.TokenDeliveryMode;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"authorization_endpoint", "backchannel_authentication_request_signing_alg_values_supported", "backchannel_token_delivery_modes_supported", "claims_supported", "code_challenge_methods_supported", "device_authorization_endpoint", "dpop_signing_alg_values_supported", "end_session_endpoint", "grant_types_supported", "introspection_endpoint", "introspection_endpoint_auth_methods_supported", "issuer", "jwks_uri", "pushed_authorization_request_endpoint", "registration_endpoint", "request_object_signing_alg_values_supported", "request_parameter_supported", "response_modes_supported", "response_types_supported", "revocation_endpoint", "revocation_endpoint_auth_methods_supported", "scopes_supported", "subject_types_supported", "token_endpoint", "token_endpoint_auth_methods_supported"})
public class OAuthMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private String authorizationEndpoint;
    public static final String JSON_PROPERTY_BACKCHANNEL_AUTHENTICATION_REQUEST_SIGNING_ALG_VALUES_SUPPORTED = "backchannel_authentication_request_signing_alg_values_supported";
    private List<SigningAlgorithm> backchannelAuthenticationRequestSigningAlgValuesSupported = null;
    public static final String JSON_PROPERTY_BACKCHANNEL_TOKEN_DELIVERY_MODES_SUPPORTED = "backchannel_token_delivery_modes_supported";
    private List<TokenDeliveryMode> backchannelTokenDeliveryModesSupported = null;
    public static final String JSON_PROPERTY_CLAIMS_SUPPORTED = "claims_supported";
    private List<String> claimsSupported = null;
    public static final String JSON_PROPERTY_CODE_CHALLENGE_METHODS_SUPPORTED = "code_challenge_methods_supported";
    private List<CodeChallengeMethod> codeChallengeMethodsSupported = null;
    public static final String JSON_PROPERTY_DEVICE_AUTHORIZATION_ENDPOINT = "device_authorization_endpoint";
    private String deviceAuthorizationEndpoint;
    public static final String JSON_PROPERTY_DPOP_SIGNING_ALG_VALUES_SUPPORTED = "dpop_signing_alg_values_supported";
    private List<DpopSigningAlgValuesSupportedEnum> dpopSigningAlgValuesSupported = null;
    public static final String JSON_PROPERTY_END_SESSION_ENDPOINT = "end_session_endpoint";
    private String endSessionEndpoint;
    public static final String JSON_PROPERTY_GRANT_TYPES_SUPPORTED = "grant_types_supported";
    private List<GrantType> grantTypesSupported = null;
    public static final String JSON_PROPERTY_INTROSPECTION_ENDPOINT = "introspection_endpoint";
    private String introspectionEndpoint;
    public static final String JSON_PROPERTY_INTROSPECTION_ENDPOINT_AUTH_METHODS_SUPPORTED = "introspection_endpoint_auth_methods_supported";
    private List<EndpointAuthMethod> introspectionEndpointAuthMethodsSupported = null;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri;
    public static final String JSON_PROPERTY_PUSHED_AUTHORIZATION_REQUEST_ENDPOINT = "pushed_authorization_request_endpoint";
    private String pushedAuthorizationRequestEndpoint;
    public static final String JSON_PROPERTY_REGISTRATION_ENDPOINT = "registration_endpoint";
    private String registrationEndpoint;
    public static final String JSON_PROPERTY_REQUEST_OBJECT_SIGNING_ALG_VALUES_SUPPORTED = "request_object_signing_alg_values_supported";
    private List<SigningAlgorithm> requestObjectSigningAlgValuesSupported = null;
    public static final String JSON_PROPERTY_REQUEST_PARAMETER_SUPPORTED = "request_parameter_supported";
    private Boolean requestParameterSupported;
    public static final String JSON_PROPERTY_RESPONSE_MODES_SUPPORTED = "response_modes_supported";
    private List<ResponseMode> responseModesSupported = null;
    public static final String JSON_PROPERTY_RESPONSE_TYPES_SUPPORTED = "response_types_supported";
    private List<ResponseTypesSupported> responseTypesSupported = null;
    public static final String JSON_PROPERTY_REVOCATION_ENDPOINT = "revocation_endpoint";
    private String revocationEndpoint;
    public static final String JSON_PROPERTY_REVOCATION_ENDPOINT_AUTH_METHODS_SUPPORTED = "revocation_endpoint_auth_methods_supported";
    private List<EndpointAuthMethod> revocationEndpointAuthMethodsSupported = null;
    public static final String JSON_PROPERTY_SCOPES_SUPPORTED = "scopes_supported";
    private List<String> scopesSupported = null;
    public static final String JSON_PROPERTY_SUBJECT_TYPES_SUPPORTED = "subject_types_supported";
    private List<SubjectType> subjectTypesSupported = null;
    public static final String JSON_PROPERTY_TOKEN_ENDPOINT = "token_endpoint";
    private String tokenEndpoint;
    public static final String JSON_PROPERTY_TOKEN_ENDPOINT_AUTH_METHODS_SUPPORTED = "token_endpoint_auth_methods_supported";
    private List<EndpointAuthMethod> tokenEndpointAuthMethodsSupported = null;

    public OAuthMetadata authorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's authorization endpoint.")
    @JsonProperty(value="authorization_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @JsonProperty(value="authorization_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public OAuthMetadata backchannelAuthenticationRequestSigningAlgValuesSupported(List<SigningAlgorithm> backchannelAuthenticationRequestSigningAlgValuesSupported) {
        this.backchannelAuthenticationRequestSigningAlgValuesSupported = backchannelAuthenticationRequestSigningAlgValuesSupported;
        return this;
    }

    public OAuthMetadata addbackchannelAuthenticationRequestSigningAlgValuesSupportedItem(SigningAlgorithm backchannelAuthenticationRequestSigningAlgValuesSupportedItem) {
        if (this.backchannelAuthenticationRequestSigningAlgValuesSupported == null) {
            this.backchannelAuthenticationRequestSigningAlgValuesSupported = new ArrayList<SigningAlgorithm>();
        }
        this.backchannelAuthenticationRequestSigningAlgValuesSupported.add(backchannelAuthenticationRequestSigningAlgValuesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<div class=\"x-lifecycle-container\"><x-lifecycle class=\"lea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></div>A list of signing algorithms that this authorization server supports for signed requests.")
    @JsonProperty(value="backchannel_authentication_request_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SigningAlgorithm> getBackchannelAuthenticationRequestSigningAlgValuesSupported() {
        return this.backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    @JsonProperty(value="backchannel_authentication_request_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelAuthenticationRequestSigningAlgValuesSupported(List<SigningAlgorithm> backchannelAuthenticationRequestSigningAlgValuesSupported) {
        this.backchannelAuthenticationRequestSigningAlgValuesSupported = backchannelAuthenticationRequestSigningAlgValuesSupported;
    }

    public OAuthMetadata backchannelTokenDeliveryModesSupported(List<TokenDeliveryMode> backchannelTokenDeliveryModesSupported) {
        this.backchannelTokenDeliveryModesSupported = backchannelTokenDeliveryModesSupported;
        return this;
    }

    public OAuthMetadata addbackchannelTokenDeliveryModesSupportedItem(TokenDeliveryMode backchannelTokenDeliveryModesSupportedItem) {
        if (this.backchannelTokenDeliveryModesSupported == null) {
            this.backchannelTokenDeliveryModesSupported = new ArrayList<TokenDeliveryMode>();
        }
        this.backchannelTokenDeliveryModesSupported.add(backchannelTokenDeliveryModesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="<div class=\"x-lifecycle-container\"><x-lifecycle class=\"lea\"></x-lifecycle> <x-lifecycle class=\"oie\"></x-lifecycle></div>The delivery modes that this authorization server supports for Client-Initiated Backchannel Authentication.")
    @JsonProperty(value="backchannel_token_delivery_modes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<TokenDeliveryMode> getBackchannelTokenDeliveryModesSupported() {
        return this.backchannelTokenDeliveryModesSupported;
    }

    @JsonProperty(value="backchannel_token_delivery_modes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBackchannelTokenDeliveryModesSupported(List<TokenDeliveryMode> backchannelTokenDeliveryModesSupported) {
        this.backchannelTokenDeliveryModesSupported = backchannelTokenDeliveryModesSupported;
    }

    public OAuthMetadata claimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
        return this;
    }

    public OAuthMetadata addclaimsSupportedItem(String claimsSupportedItem) {
        if (this.claimsSupported == null) {
            this.claimsSupported = new ArrayList<String>();
        }
        this.claimsSupported.add(claimsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the claims supported by this authorization server.")
    @JsonProperty(value="claims_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @JsonProperty(value="claims_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public OAuthMetadata codeChallengeMethodsSupported(List<CodeChallengeMethod> codeChallengeMethodsSupported) {
        this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
        return this;
    }

    public OAuthMetadata addcodeChallengeMethodsSupportedItem(CodeChallengeMethod codeChallengeMethodsSupportedItem) {
        if (this.codeChallengeMethodsSupported == null) {
            this.codeChallengeMethodsSupported = new ArrayList<CodeChallengeMethod>();
        }
        this.codeChallengeMethodsSupported.add(codeChallengeMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of PKCE code challenge methods supported by this authorization server.")
    @JsonProperty(value="code_challenge_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<CodeChallengeMethod> getCodeChallengeMethodsSupported() {
        return this.codeChallengeMethodsSupported;
    }

    @JsonProperty(value="code_challenge_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCodeChallengeMethodsSupported(List<CodeChallengeMethod> codeChallengeMethodsSupported) {
        this.codeChallengeMethodsSupported = codeChallengeMethodsSupported;
    }

    public OAuthMetadata deviceAuthorizationEndpoint(String deviceAuthorizationEndpoint) {
        this.deviceAuthorizationEndpoint = deviceAuthorizationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="device_authorization_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceAuthorizationEndpoint() {
        return this.deviceAuthorizationEndpoint;
    }

    @JsonProperty(value="device_authorization_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceAuthorizationEndpoint(String deviceAuthorizationEndpoint) {
        this.deviceAuthorizationEndpoint = deviceAuthorizationEndpoint;
    }

    public OAuthMetadata dpopSigningAlgValuesSupported(List<DpopSigningAlgValuesSupportedEnum> dpopSigningAlgValuesSupported) {
        this.dpopSigningAlgValuesSupported = dpopSigningAlgValuesSupported;
        return this;
    }

    public OAuthMetadata adddpopSigningAlgValuesSupportedItem(DpopSigningAlgValuesSupportedEnum dpopSigningAlgValuesSupportedItem) {
        if (this.dpopSigningAlgValuesSupported == null) {
            this.dpopSigningAlgValuesSupported = new ArrayList<DpopSigningAlgValuesSupportedEnum>();
        }
        this.dpopSigningAlgValuesSupported.add(dpopSigningAlgValuesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of signing algorithms supported by this authorization server for Demonstrating Proof-of-Possession (DPoP) JWTs.")
    @JsonProperty(value="dpop_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<DpopSigningAlgValuesSupportedEnum> getDpopSigningAlgValuesSupported() {
        return this.dpopSigningAlgValuesSupported;
    }

    @JsonProperty(value="dpop_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpopSigningAlgValuesSupported(List<DpopSigningAlgValuesSupportedEnum> dpopSigningAlgValuesSupported) {
        this.dpopSigningAlgValuesSupported = dpopSigningAlgValuesSupported;
    }

    public OAuthMetadata endSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's logout endpoint.")
    @JsonProperty(value="end_session_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEndSessionEndpoint() {
        return this.endSessionEndpoint;
    }

    @JsonProperty(value="end_session_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndSessionEndpoint(String endSessionEndpoint) {
        this.endSessionEndpoint = endSessionEndpoint;
    }

    public OAuthMetadata grantTypesSupported(List<GrantType> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
        return this;
    }

    public OAuthMetadata addgrantTypesSupportedItem(GrantType grantTypesSupportedItem) {
        if (this.grantTypesSupported == null) {
            this.grantTypesSupported = new ArrayList<GrantType>();
        }
        this.grantTypesSupported.add(grantTypesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the grant type values that this authorization server supports.")
    @JsonProperty(value="grant_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<GrantType> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @JsonProperty(value="grant_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantTypesSupported(List<GrantType> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public OAuthMetadata introspectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's introspection endpoint.")
    @JsonProperty(value="introspection_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIntrospectionEndpoint() {
        return this.introspectionEndpoint;
    }

    @JsonProperty(value="introspection_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntrospectionEndpoint(String introspectionEndpoint) {
        this.introspectionEndpoint = introspectionEndpoint;
    }

    public OAuthMetadata introspectionEndpointAuthMethodsSupported(List<EndpointAuthMethod> introspectionEndpointAuthMethodsSupported) {
        this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
        return this;
    }

    public OAuthMetadata addintrospectionEndpointAuthMethodsSupportedItem(EndpointAuthMethod introspectionEndpointAuthMethodsSupportedItem) {
        if (this.introspectionEndpointAuthMethodsSupported == null) {
            this.introspectionEndpointAuthMethodsSupported = new ArrayList<EndpointAuthMethod>();
        }
        this.introspectionEndpointAuthMethodsSupported.add(introspectionEndpointAuthMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of client authentication methods supported by this introspection endpoint.")
    @JsonProperty(value="introspection_endpoint_auth_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EndpointAuthMethod> getIntrospectionEndpointAuthMethodsSupported() {
        return this.introspectionEndpointAuthMethodsSupported;
    }

    @JsonProperty(value="introspection_endpoint_auth_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntrospectionEndpointAuthMethodsSupported(List<EndpointAuthMethod> introspectionEndpointAuthMethodsSupported) {
        this.introspectionEndpointAuthMethodsSupported = introspectionEndpointAuthMethodsSupported;
    }

    public OAuthMetadata issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The authorization server's issuer identifier. In the context of this document, this is your authorization server's base URL. This becomes the `iss` claim in an access token.")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public OAuthMetadata jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's JSON Web Key Set document.")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OAuthMetadata pushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="pushed_authorization_request_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPushedAuthorizationRequestEndpoint() {
        return this.pushedAuthorizationRequestEndpoint;
    }

    @JsonProperty(value="pushed_authorization_request_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPushedAuthorizationRequestEndpoint(String pushedAuthorizationRequestEndpoint) {
        this.pushedAuthorizationRequestEndpoint = pushedAuthorizationRequestEndpoint;
    }

    public OAuthMetadata registrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's JSON Web Key Set document.")
    @JsonProperty(value="registration_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRegistrationEndpoint() {
        return this.registrationEndpoint;
    }

    @JsonProperty(value="registration_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRegistrationEndpoint(String registrationEndpoint) {
        this.registrationEndpoint = registrationEndpoint;
    }

    public OAuthMetadata requestObjectSigningAlgValuesSupported(List<SigningAlgorithm> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
        return this;
    }

    public OAuthMetadata addrequestObjectSigningAlgValuesSupportedItem(SigningAlgorithm requestObjectSigningAlgValuesSupportedItem) {
        if (this.requestObjectSigningAlgValuesSupported == null) {
            this.requestObjectSigningAlgValuesSupported = new ArrayList<SigningAlgorithm>();
        }
        this.requestObjectSigningAlgValuesSupported.add(requestObjectSigningAlgValuesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of signing algorithms that this authorization server supports for signed requests.")
    @JsonProperty(value="request_object_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SigningAlgorithm> getRequestObjectSigningAlgValuesSupported() {
        return this.requestObjectSigningAlgValuesSupported;
    }

    @JsonProperty(value="request_object_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestObjectSigningAlgValuesSupported(List<SigningAlgorithm> requestObjectSigningAlgValuesSupported) {
        this.requestObjectSigningAlgValuesSupported = requestObjectSigningAlgValuesSupported;
    }

    public OAuthMetadata requestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Indicates if Request Parameters are supported by this authorization server.")
    @JsonProperty(value="request_parameter_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Boolean getRequestParameterSupported() {
        return this.requestParameterSupported;
    }

    @JsonProperty(value="request_parameter_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRequestParameterSupported(Boolean requestParameterSupported) {
        this.requestParameterSupported = requestParameterSupported;
    }

    public OAuthMetadata responseModesSupported(List<ResponseMode> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
        return this;
    }

    public OAuthMetadata addresponseModesSupportedItem(ResponseMode responseModesSupportedItem) {
        if (this.responseModesSupported == null) {
            this.responseModesSupported = new ArrayList<ResponseMode>();
        }
        this.responseModesSupported.add(responseModesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the `response_mode` values that this authorization server supports. More information here.")
    @JsonProperty(value="response_modes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ResponseMode> getResponseModesSupported() {
        return this.responseModesSupported;
    }

    @JsonProperty(value="response_modes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseModesSupported(List<ResponseMode> responseModesSupported) {
        this.responseModesSupported = responseModesSupported;
    }

    public OAuthMetadata responseTypesSupported(List<ResponseTypesSupported> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
        return this;
    }

    public OAuthMetadata addresponseTypesSupportedItem(ResponseTypesSupported responseTypesSupportedItem) {
        if (this.responseTypesSupported == null) {
            this.responseTypesSupported = new ArrayList<ResponseTypesSupported>();
        }
        this.responseTypesSupported.add(responseTypesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the `response_type` values that this authorization server supports. Can be a combination of `code`, `token`, and `id_token`.")
    @JsonProperty(value="response_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<ResponseTypesSupported> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @JsonProperty(value="response_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResponseTypesSupported(List<ResponseTypesSupported> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public OAuthMetadata revocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's revocation endpoint.")
    @JsonProperty(value="revocation_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    @JsonProperty(value="revocation_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRevocationEndpoint(String revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public OAuthMetadata revocationEndpointAuthMethodsSupported(List<EndpointAuthMethod> revocationEndpointAuthMethodsSupported) {
        this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
        return this;
    }

    public OAuthMetadata addrevocationEndpointAuthMethodsSupportedItem(EndpointAuthMethod revocationEndpointAuthMethodsSupportedItem) {
        if (this.revocationEndpointAuthMethodsSupported == null) {
            this.revocationEndpointAuthMethodsSupported = new ArrayList<EndpointAuthMethod>();
        }
        this.revocationEndpointAuthMethodsSupported.add(revocationEndpointAuthMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of client authentication methods supported by this revocation endpoint.")
    @JsonProperty(value="revocation_endpoint_auth_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EndpointAuthMethod> getRevocationEndpointAuthMethodsSupported() {
        return this.revocationEndpointAuthMethodsSupported;
    }

    @JsonProperty(value="revocation_endpoint_auth_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRevocationEndpointAuthMethodsSupported(List<EndpointAuthMethod> revocationEndpointAuthMethodsSupported) {
        this.revocationEndpointAuthMethodsSupported = revocationEndpointAuthMethodsSupported;
    }

    public OAuthMetadata scopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
        return this;
    }

    public OAuthMetadata addscopesSupportedItem(String scopesSupportedItem) {
        if (this.scopesSupported == null) {
            this.scopesSupported = new ArrayList<String>();
        }
        this.scopesSupported.add(scopesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the scope values that this authorization server supports.")
    @JsonProperty(value="scopes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    @JsonProperty(value="scopes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public OAuthMetadata subjectTypesSupported(List<SubjectType> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
        return this;
    }

    public OAuthMetadata addsubjectTypesSupportedItem(SubjectType subjectTypesSupportedItem) {
        if (this.subjectTypesSupported == null) {
            this.subjectTypesSupported = new ArrayList<SubjectType>();
        }
        this.subjectTypesSupported.add(subjectTypesSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of the Subject Identifier types that this authorization server supports. Valid types include `pairwise` and `public`, but only `public` is currently supported. See the [Subject Identifier Types](https://openid.net/specs/openid-connect-core-1_0.html#SubjectIDTypes) section in the OpenID Connect specification.")
    @JsonProperty(value="subject_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SubjectType> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    @JsonProperty(value="subject_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubjectTypesSupported(List<SubjectType> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public OAuthMetadata tokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URL of the authorization server's token endpoint.")
    @JsonProperty(value="token_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @JsonProperty(value="token_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public OAuthMetadata tokenEndpointAuthMethodsSupported(List<EndpointAuthMethod> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
        return this;
    }

    public OAuthMetadata addtokenEndpointAuthMethodsSupportedItem(EndpointAuthMethod tokenEndpointAuthMethodsSupportedItem) {
        if (this.tokenEndpointAuthMethodsSupported == null) {
            this.tokenEndpointAuthMethodsSupported = new ArrayList<EndpointAuthMethod>();
        }
        this.tokenEndpointAuthMethodsSupported.add(tokenEndpointAuthMethodsSupportedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of client authentication methods supported by this token endpoint.")
    @JsonProperty(value="token_endpoint_auth_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<EndpointAuthMethod> getTokenEndpointAuthMethodsSupported() {
        return this.tokenEndpointAuthMethodsSupported;
    }

    @JsonProperty(value="token_endpoint_auth_methods_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenEndpointAuthMethodsSupported(List<EndpointAuthMethod> tokenEndpointAuthMethodsSupported) {
        this.tokenEndpointAuthMethodsSupported = tokenEndpointAuthMethodsSupported;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthMetadata oauthMetadata = (OAuthMetadata)o;
        return Objects.equals(this.authorizationEndpoint, oauthMetadata.authorizationEndpoint) && Objects.equals(this.backchannelAuthenticationRequestSigningAlgValuesSupported, oauthMetadata.backchannelAuthenticationRequestSigningAlgValuesSupported) && Objects.equals(this.backchannelTokenDeliveryModesSupported, oauthMetadata.backchannelTokenDeliveryModesSupported) && Objects.equals(this.claimsSupported, oauthMetadata.claimsSupported) && Objects.equals(this.codeChallengeMethodsSupported, oauthMetadata.codeChallengeMethodsSupported) && Objects.equals(this.deviceAuthorizationEndpoint, oauthMetadata.deviceAuthorizationEndpoint) && Objects.equals(this.dpopSigningAlgValuesSupported, oauthMetadata.dpopSigningAlgValuesSupported) && Objects.equals(this.endSessionEndpoint, oauthMetadata.endSessionEndpoint) && Objects.equals(this.grantTypesSupported, oauthMetadata.grantTypesSupported) && Objects.equals(this.introspectionEndpoint, oauthMetadata.introspectionEndpoint) && Objects.equals(this.introspectionEndpointAuthMethodsSupported, oauthMetadata.introspectionEndpointAuthMethodsSupported) && Objects.equals(this.issuer, oauthMetadata.issuer) && Objects.equals(this.jwksUri, oauthMetadata.jwksUri) && Objects.equals(this.pushedAuthorizationRequestEndpoint, oauthMetadata.pushedAuthorizationRequestEndpoint) && Objects.equals(this.registrationEndpoint, oauthMetadata.registrationEndpoint) && Objects.equals(this.requestObjectSigningAlgValuesSupported, oauthMetadata.requestObjectSigningAlgValuesSupported) && Objects.equals(this.requestParameterSupported, oauthMetadata.requestParameterSupported) && Objects.equals(this.responseModesSupported, oauthMetadata.responseModesSupported) && Objects.equals(this.responseTypesSupported, oauthMetadata.responseTypesSupported) && Objects.equals(this.revocationEndpoint, oauthMetadata.revocationEndpoint) && Objects.equals(this.revocationEndpointAuthMethodsSupported, oauthMetadata.revocationEndpointAuthMethodsSupported) && Objects.equals(this.scopesSupported, oauthMetadata.scopesSupported) && Objects.equals(this.subjectTypesSupported, oauthMetadata.subjectTypesSupported) && Objects.equals(this.tokenEndpoint, oauthMetadata.tokenEndpoint) && Objects.equals(this.tokenEndpointAuthMethodsSupported, oauthMetadata.tokenEndpointAuthMethodsSupported);
    }

    public int hashCode() {
        return Objects.hash(this.authorizationEndpoint, this.backchannelAuthenticationRequestSigningAlgValuesSupported, this.backchannelTokenDeliveryModesSupported, this.claimsSupported, this.codeChallengeMethodsSupported, this.deviceAuthorizationEndpoint, this.dpopSigningAlgValuesSupported, this.endSessionEndpoint, this.grantTypesSupported, this.introspectionEndpoint, this.introspectionEndpointAuthMethodsSupported, this.issuer, this.jwksUri, this.pushedAuthorizationRequestEndpoint, this.registrationEndpoint, this.requestObjectSigningAlgValuesSupported, this.requestParameterSupported, this.responseModesSupported, this.responseTypesSupported, this.revocationEndpoint, this.revocationEndpointAuthMethodsSupported, this.scopesSupported, this.subjectTypesSupported, this.tokenEndpoint, this.tokenEndpointAuthMethodsSupported);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthMetadata {\n");
        sb.append("    authorizationEndpoint: ").append(this.toIndentedString(this.authorizationEndpoint)).append("\n");
        sb.append("    backchannelAuthenticationRequestSigningAlgValuesSupported: ").append(this.toIndentedString(this.backchannelAuthenticationRequestSigningAlgValuesSupported)).append("\n");
        sb.append("    backchannelTokenDeliveryModesSupported: ").append(this.toIndentedString(this.backchannelTokenDeliveryModesSupported)).append("\n");
        sb.append("    claimsSupported: ").append(this.toIndentedString(this.claimsSupported)).append("\n");
        sb.append("    codeChallengeMethodsSupported: ").append(this.toIndentedString(this.codeChallengeMethodsSupported)).append("\n");
        sb.append("    deviceAuthorizationEndpoint: ").append(this.toIndentedString(this.deviceAuthorizationEndpoint)).append("\n");
        sb.append("    dpopSigningAlgValuesSupported: ").append(this.toIndentedString(this.dpopSigningAlgValuesSupported)).append("\n");
        sb.append("    endSessionEndpoint: ").append(this.toIndentedString(this.endSessionEndpoint)).append("\n");
        sb.append("    grantTypesSupported: ").append(this.toIndentedString(this.grantTypesSupported)).append("\n");
        sb.append("    introspectionEndpoint: ").append(this.toIndentedString(this.introspectionEndpoint)).append("\n");
        sb.append("    introspectionEndpointAuthMethodsSupported: ").append(this.toIndentedString(this.introspectionEndpointAuthMethodsSupported)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    pushedAuthorizationRequestEndpoint: ").append(this.toIndentedString(this.pushedAuthorizationRequestEndpoint)).append("\n");
        sb.append("    registrationEndpoint: ").append(this.toIndentedString(this.registrationEndpoint)).append("\n");
        sb.append("    requestObjectSigningAlgValuesSupported: ").append(this.toIndentedString(this.requestObjectSigningAlgValuesSupported)).append("\n");
        sb.append("    requestParameterSupported: ").append(this.toIndentedString(this.requestParameterSupported)).append("\n");
        sb.append("    responseModesSupported: ").append(this.toIndentedString(this.responseModesSupported)).append("\n");
        sb.append("    responseTypesSupported: ").append(this.toIndentedString(this.responseTypesSupported)).append("\n");
        sb.append("    revocationEndpoint: ").append(this.toIndentedString(this.revocationEndpoint)).append("\n");
        sb.append("    revocationEndpointAuthMethodsSupported: ").append(this.toIndentedString(this.revocationEndpointAuthMethodsSupported)).append("\n");
        sb.append("    scopesSupported: ").append(this.toIndentedString(this.scopesSupported)).append("\n");
        sb.append("    subjectTypesSupported: ").append(this.toIndentedString(this.subjectTypesSupported)).append("\n");
        sb.append("    tokenEndpoint: ").append(this.toIndentedString(this.tokenEndpoint)).append("\n");
        sb.append("    tokenEndpointAuthMethodsSupported: ").append(this.toIndentedString(this.tokenEndpointAuthMethodsSupported)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum DpopSigningAlgValuesSupportedEnum {
        ES256(String.valueOf("ES256")),
        ES384(String.valueOf("ES384")),
        ES512(String.valueOf("ES512")),
        RS256(String.valueOf("RS256")),
        RS384(String.valueOf("RS384")),
        RS512(String.valueOf("RS512")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private DpopSigningAlgValuesSupportedEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DpopSigningAlgValuesSupportedEnum fromValue(String value) {
            for (DpopSigningAlgValuesSupportedEnum b : DpopSigningAlgValuesSupportedEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

