/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SamlAttributeStatement;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Contains SAML 2.0 sign-on mode attributes. > **Note:** Set `destinationOverride` to configure any other SAML 2.0 attributes in this section.")
@JsonPropertyOrder(value={"audienceOverride", "configuredAttributeStatements", "defaultRelayState", "destinationOverride", "recipientOverride", "samlAssertionLifetimeSeconds", "ssoAcsUrlOverride"})
public class OINSaml20ApplicationSettingsSignOn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private String audienceOverride;
    public static final String JSON_PROPERTY_CONFIGURED_ATTRIBUTE_STATEMENTS = "configuredAttributeStatements";
    private List<SamlAttributeStatement> configuredAttributeStatements = null;
    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private String defaultRelayState;
    public static final String JSON_PROPERTY_DESTINATION_OVERRIDE = "destinationOverride";
    private String destinationOverride;
    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private String recipientOverride;
    public static final String JSON_PROPERTY_SAML_ASSERTION_LIFETIME_SECONDS = "samlAssertionLifetimeSeconds";
    private Integer samlAssertionLifetimeSeconds;
    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private String ssoAcsUrlOverride;

    public OINSaml20ApplicationSettingsSignOn audienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Audience override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudienceOverride() {
        return this.audienceOverride;
    }

    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public OINSaml20ApplicationSettingsSignOn configuredAttributeStatements(List<SamlAttributeStatement> configuredAttributeStatements) {
        this.configuredAttributeStatements = configuredAttributeStatements;
        return this;
    }

    public OINSaml20ApplicationSettingsSignOn addconfiguredAttributeStatementsItem(SamlAttributeStatement configuredAttributeStatementsItem) {
        if (this.configuredAttributeStatements == null) {
            this.configuredAttributeStatements = new ArrayList<SamlAttributeStatement>();
        }
        this.configuredAttributeStatements.add(configuredAttributeStatementsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="configuredAttributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<SamlAttributeStatement> getConfiguredAttributeStatements() {
        return this.configuredAttributeStatements;
    }

    @JsonProperty(value="configuredAttributeStatements")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConfiguredAttributeStatements(List<SamlAttributeStatement> configuredAttributeStatements) {
        this.configuredAttributeStatements = configuredAttributeStatements;
    }

    public OINSaml20ApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Identifies a specific application resource in an IdP-initiated SSO scenario")
    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultRelayState() {
        return this.defaultRelayState;
    }

    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public OINSaml20ApplicationSettingsSignOn destinationOverride(String destinationOverride) {
        this.destinationOverride = destinationOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Destination override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="destinationOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDestinationOverride() {
        return this.destinationOverride;
    }

    @JsonProperty(value="destinationOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationOverride(String destinationOverride) {
        this.destinationOverride = destinationOverride;
    }

    public OINSaml20ApplicationSettingsSignOn recipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Recipient override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecipientOverride() {
        return this.recipientOverride;
    }

    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public OINSaml20ApplicationSettingsSignOn samlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="3600", value="Determines the SAML app session lifetimes with Okta")
    @JsonProperty(value="samlAssertionLifetimeSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getSamlAssertionLifetimeSeconds() {
        return this.samlAssertionLifetimeSeconds;
    }

    @JsonProperty(value="samlAssertionLifetimeSeconds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamlAssertionLifetimeSeconds(Integer samlAssertionLifetimeSeconds) {
        this.samlAssertionLifetimeSeconds = samlAssertionLifetimeSeconds;
    }

    public OINSaml20ApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Assertion Consumer Service (ACS) URL override for CASB configuration. See [CASB config guide](https://help.okta.com/en-us/Content/Topics/Apps/CASB-config-guide.htm).")
    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSsoAcsUrlOverride() {
        return this.ssoAcsUrlOverride;
    }

    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OINSaml20ApplicationSettingsSignOn oiNSaml20ApplicationSettingsSignOn = (OINSaml20ApplicationSettingsSignOn)o;
        return Objects.equals(this.audienceOverride, oiNSaml20ApplicationSettingsSignOn.audienceOverride) && Objects.equals(this.configuredAttributeStatements, oiNSaml20ApplicationSettingsSignOn.configuredAttributeStatements) && Objects.equals(this.defaultRelayState, oiNSaml20ApplicationSettingsSignOn.defaultRelayState) && Objects.equals(this.destinationOverride, oiNSaml20ApplicationSettingsSignOn.destinationOverride) && Objects.equals(this.recipientOverride, oiNSaml20ApplicationSettingsSignOn.recipientOverride) && Objects.equals(this.samlAssertionLifetimeSeconds, oiNSaml20ApplicationSettingsSignOn.samlAssertionLifetimeSeconds) && Objects.equals(this.ssoAcsUrlOverride, oiNSaml20ApplicationSettingsSignOn.ssoAcsUrlOverride);
    }

    public int hashCode() {
        return Objects.hash(this.audienceOverride, this.configuredAttributeStatements, this.defaultRelayState, this.destinationOverride, this.recipientOverride, this.samlAssertionLifetimeSeconds, this.ssoAcsUrlOverride);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OINSaml20ApplicationSettingsSignOn {\n");
        sb.append("    audienceOverride: ").append(this.toIndentedString(this.audienceOverride)).append("\n");
        sb.append("    configuredAttributeStatements: ").append(this.toIndentedString(this.configuredAttributeStatements)).append("\n");
        sb.append("    defaultRelayState: ").append(this.toIndentedString(this.defaultRelayState)).append("\n");
        sb.append("    destinationOverride: ").append(this.toIndentedString(this.destinationOverride)).append("\n");
        sb.append("    recipientOverride: ").append(this.toIndentedString(this.recipientOverride)).append("\n");
        sb.append("    samlAssertionLifetimeSeconds: ").append(this.toIndentedString(this.samlAssertionLifetimeSeconds)).append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(this.toIndentedString(this.ssoAcsUrlOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

