/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.PolicySubjectMatchType;
import com.okta.sdk.resource.model.PolicyUserNameTemplate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Specifies the behavior for establishing, validating, and matching a username for an IdP User")
@JsonPropertyOrder(value={"filter", "matchAttribute", "matchType", "userNameTemplate"})
public class PolicySubject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_FILTER = "filter";
    private String filter;
    public static final String JSON_PROPERTY_MATCH_ATTRIBUTE = "matchAttribute";
    private String matchAttribute;
    public static final String JSON_PROPERTY_MATCH_TYPE = "matchType";
    private PolicySubjectMatchType matchType;
    public static final String JSON_PROPERTY_USER_NAME_TEMPLATE = "userNameTemplate";
    private PolicyUserNameTemplate userNameTemplate;

    public PolicySubject filter(String filter) {
        this.filter = filter;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="(\\S+@example\\.com)", value="Optional [regular expression pattern](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Regular_expressions) used to filter untrusted IdP usernames. * As a best security practice, you should define a regular expression pattern to filter untrusted IdP usernames. This is especially important if multiple IdPs are connected to your org. The filter prevents an IdP from issuing an assertion for any User, including partners or directory Users in your Okta org. * For example, the filter pattern `(\\S+@example\\.com)` allows only Users that have an `@example.com` username suffix. It rejects assertions that have any other suffix such as `@corp.example.com` or `@partner.com`. * Only `SAML2` and `OIDC` IdP providers support the `filter` property.")
    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFilter() {
        return this.filter;
    }

    @JsonProperty(value="filter")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFilter(String filter) {
        this.filter = filter;
    }

    public PolicySubject matchAttribute(String matchAttribute) {
        this.matchAttribute = matchAttribute;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="login", value="Okta User profile attribute for matching a transformed IdP username. Only for matchType `CUSTOM_ATTRIBUTE`. The `matchAttribute` must be a valid Okta User profile attribute of one of the following types: * String (with no format or 'email' format only) * Integer * Number")
    @JsonProperty(value="matchAttribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getMatchAttribute() {
        return this.matchAttribute;
    }

    @JsonProperty(value="matchAttribute")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMatchAttribute(String matchAttribute) {
        this.matchAttribute = matchAttribute;
    }

    public PolicySubject matchType(PolicySubjectMatchType matchType) {
        this.matchType = matchType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="matchType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicySubjectMatchType getMatchType() {
        return this.matchType;
    }

    @JsonProperty(value="matchType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMatchType(PolicySubjectMatchType matchType) {
        this.matchType = matchType;
    }

    public PolicySubject userNameTemplate(PolicyUserNameTemplate userNameTemplate) {
        this.userNameTemplate = userNameTemplate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="userNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PolicyUserNameTemplate getUserNameTemplate() {
        return this.userNameTemplate;
    }

    @JsonProperty(value="userNameTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserNameTemplate(PolicyUserNameTemplate userNameTemplate) {
        this.userNameTemplate = userNameTemplate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicySubject policySubject = (PolicySubject)o;
        return Objects.equals(this.filter, policySubject.filter) && Objects.equals(this.matchAttribute, policySubject.matchAttribute) && Objects.equals((Object)this.matchType, (Object)policySubject.matchType) && Objects.equals(this.userNameTemplate, policySubject.userNameTemplate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filter, this.matchAttribute, this.matchType, this.userNameTemplate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicySubject {\n");
        sb.append("    filter: ").append(this.toIndentedString(this.filter)).append("\n");
        sb.append("    matchAttribute: ").append(this.toIndentedString(this.matchAttribute)).append("\n");
        sb.append("    matchType: ").append(this.toIndentedString((Object)this.matchType)).append("\n");
        sb.append("    userNameTemplate: ").append(this.toIndentedString(this.userNameTemplate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

