/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"description", "email", "name", "ownerGroupIds", "ownerUserIds", "username"})
public class PrivilegedAccountForUpdate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DESCRIPTION = "description";
    private String description;
    public static final String JSON_PROPERTY_EMAIL = "email";
    private String email;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_OWNER_GROUP_IDS = "ownerGroupIds";
    private List<String> ownerGroupIds = null;
    public static final String JSON_PROPERTY_OWNER_USER_IDS = "ownerUserIds";
    private List<String> ownerUserIds = null;
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username;

    public PrivilegedAccountForUpdate description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="This is for accessing AWS Prod-5", value="The description of the Privileged Account")
    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDescription(String description) {
        this.description = description;
    }

    public PrivilegedAccountForUpdate email(String email) {
        this.email = email;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="foo@bar.com", value="The email address for the Okta Universal Directory Account")
    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getEmail() {
        return this.email;
    }

    @JsonProperty(value="email")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmail(String email) {
        this.email = email;
    }

    public PrivilegedAccountForUpdate name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="AWS Prod-5 account", value="The human-readable name for the Privileged Account")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public PrivilegedAccountForUpdate ownerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
        return this;
    }

    public PrivilegedAccountForUpdate addownerGroupIdsItem(String ownerGroupIdsItem) {
        if (this.ownerGroupIds == null) {
            this.ownerGroupIds = new ArrayList<String>();
        }
        this.ownerGroupIds.add(ownerGroupIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00g57qp78yZT2XBA40g7\"]", value="A list of IDs of the Okta groups who own the Privileged Account")
    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerGroupIds() {
        return this.ownerGroupIds;
    }

    @JsonProperty(value="ownerGroupIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerGroupIds(List<String> ownerGroupIds) {
        this.ownerGroupIds = ownerGroupIds;
    }

    public PrivilegedAccountForUpdate ownerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
        return this;
    }

    public PrivilegedAccountForUpdate addownerUserIdsItem(String ownerUserIdsItem) {
        if (this.ownerUserIds == null) {
            this.ownerUserIds = new ArrayList<String>();
        }
        this.ownerUserIds.add(ownerUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(example="[\"00u11s48P9zGW8yqm0g5\"]", value="A list of IDs of the Okta users who own the Privileged Account")
    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getOwnerUserIds() {
        return this.ownerUserIds;
    }

    @JsonProperty(value="ownerUserIds")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOwnerUserIds(List<String> ownerUserIds) {
        this.ownerUserIds = ownerUserIds;
    }

    public PrivilegedAccountForUpdate username(String username) {
        this.username = username;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="testuser@example.com", value="The username associated with the Privileged Account")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedAccountForUpdate privilegedAccountForUpdate = (PrivilegedAccountForUpdate)o;
        return Objects.equals(this.description, privilegedAccountForUpdate.description) && Objects.equals(this.email, privilegedAccountForUpdate.email) && Objects.equals(this.name, privilegedAccountForUpdate.name) && Objects.equals(this.ownerGroupIds, privilegedAccountForUpdate.ownerGroupIds) && Objects.equals(this.ownerUserIds, privilegedAccountForUpdate.ownerUserIds) && Objects.equals(this.username, privilegedAccountForUpdate.username);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.email, this.name, this.ownerGroupIds, this.ownerUserIds, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedAccountForUpdate {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    ownerGroupIds: ").append(this.toIndentedString(this.ownerGroupIds)).append("\n");
        sb.append("    ownerUserIds: ").append(this.toIndentedString(this.ownerUserIds)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

