/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Update request for a privileged resource")
@JsonPropertyOrder(value={"profile", "userName"})
public class PrivilegedResourceUpdateRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_PROFILE = "profile";
    private Map<String, Object> profile = null;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName;

    @Nullable
    @ApiModelProperty(value="Specific profile properties for the privileged account")
    @JsonProperty(value="profile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, Object> getProfile() {
        return this.profile;
    }

    public PrivilegedResourceUpdateRequest userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="testuser@example.com", value="The username associated with the privileged resource")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrivilegedResourceUpdateRequest privilegedResourceUpdateRequest = (PrivilegedResourceUpdateRequest)o;
        return Objects.equals(this.profile, privilegedResourceUpdateRequest.profile) && Objects.equals(this.userName, privilegedResourceUpdateRequest.userName);
    }

    public int hashCode() {
        return Objects.hash(this.profile, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PrivilegedResourceUpdateRequest {\n");
        sb.append("    profile: ").append(this.toIndentedString(this.profile)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

