/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.okta.sdk.resource.model.OAuthCredentials;
import com.okta.sdk.resource.model.OAuthEndpoints;
import com.okta.sdk.resource.model.OidcAlgorithms;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Protocol settings for authentication using the [OpenID Connect Protocol](http://openid.net/specs/openid-connect-core-1_0.html#CodeFlowAuth)")
@JsonPropertyOrder(value={"algorithms", "credentials", "endpoints", "scopes", "type"})
public class ProtocolOidc
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ALGORITHMS = "algorithms";
    private OidcAlgorithms algorithms;
    public static final String JSON_PROPERTY_CREDENTIALS = "credentials";
    private OAuthCredentials credentials;
    public static final String JSON_PROPERTY_ENDPOINTS = "endpoints";
    private OAuthEndpoints endpoints;
    public static final String JSON_PROPERTY_SCOPES = "scopes";
    private List<String> scopes = null;
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;

    public ProtocolOidc algorithms(OidcAlgorithms algorithms) {
        this.algorithms = algorithms;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OidcAlgorithms getAlgorithms() {
        return this.algorithms;
    }

    @JsonProperty(value="algorithms")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAlgorithms(OidcAlgorithms algorithms) {
        this.algorithms = algorithms;
    }

    public ProtocolOidc credentials(OAuthCredentials credentials) {
        this.credentials = credentials;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthCredentials getCredentials() {
        return this.credentials;
    }

    @JsonProperty(value="credentials")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCredentials(OAuthCredentials credentials) {
        this.credentials = credentials;
    }

    public ProtocolOidc endpoints(OAuthEndpoints endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OAuthEndpoints getEndpoints() {
        return this.endpoints;
    }

    @JsonProperty(value="endpoints")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEndpoints(OAuthEndpoints endpoints) {
        this.endpoints = endpoints;
    }

    public ProtocolOidc scopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public ProtocolOidc addscopesItem(String scopesItem) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(scopesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OpenID Connect and IdP-defined permission bundles to request delegated access from the User > **Note:** The [Identity Provider type](https://developer.okta.com/docs/api/openapi/okta-management/management/tag/IdentityProvider/#tag/IdentityProvider/operation/createIdentityProvider!path=type&t=request) table lists the scopes that are supported for each Identity Provider.")
    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getScopes() {
        return this.scopes;
    }

    @JsonProperty(value="scopes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public ProtocolOidc type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OpenID Connect Authorization Code flow")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtocolOidc protocolOidc = (ProtocolOidc)o;
        return Objects.equals(this.algorithms, protocolOidc.algorithms) && Objects.equals(this.credentials, protocolOidc.credentials) && Objects.equals(this.endpoints, protocolOidc.endpoints) && Objects.equals(this.scopes, protocolOidc.scopes) && Objects.equals((Object)this.type, (Object)protocolOidc.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.algorithms, this.credentials, this.endpoints, this.scopes, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ProtocolOidc {\n");
        sb.append("    algorithms: ").append(this.toIndentedString(this.algorithms)).append("\n");
        sb.append("    credentials: ").append(this.toIndentedString(this.credentials)).append("\n");
        sb.append("    endpoints: ").append(this.toIndentedString(this.endpoints)).append("\n");
        sb.append("    scopes: ").append(this.toIndentedString(this.scopes)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        OIDC(String.valueOf("OIDC")),
        UNKNOWN_DEFAULT_OPEN_API(String.valueOf("unknown_default_open_api"));

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }
}

