/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionAuthentication;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionClaimsValue;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionConditions;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionLifetime;
import com.okta.sdk.resource.model.SAMLPayLoadDataAssertionSubject;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details of the SAML assertion that was generated")
@JsonPropertyOrder(value={"subject", "authentication", "conditions", "claims", "lifetime"})
@JsonTypeName(value="SAMLPayLoad_data_assertion")
public class SAMLPayLoadDataAssertion
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private SAMLPayLoadDataAssertionSubject subject;
    public static final String JSON_PROPERTY_AUTHENTICATION = "authentication";
    private SAMLPayLoadDataAssertionAuthentication authentication;
    public static final String JSON_PROPERTY_CONDITIONS = "conditions";
    private SAMLPayLoadDataAssertionConditions conditions;
    public static final String JSON_PROPERTY_CLAIMS = "claims";
    private Map<String, SAMLPayLoadDataAssertionClaimsValue> claims = null;
    public static final String JSON_PROPERTY_LIFETIME = "lifetime";
    private SAMLPayLoadDataAssertionLifetime lifetime;

    public SAMLPayLoadDataAssertion subject(SAMLPayLoadDataAssertionSubject subject) {
        this.subject = subject;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SAMLPayLoadDataAssertionSubject getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(SAMLPayLoadDataAssertionSubject subject) {
        this.subject = subject;
    }

    public SAMLPayLoadDataAssertion authentication(SAMLPayLoadDataAssertionAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SAMLPayLoadDataAssertionAuthentication getAuthentication() {
        return this.authentication;
    }

    @JsonProperty(value="authentication")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthentication(SAMLPayLoadDataAssertionAuthentication authentication) {
        this.authentication = authentication;
    }

    public SAMLPayLoadDataAssertion conditions(SAMLPayLoadDataAssertionConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SAMLPayLoadDataAssertionConditions getConditions() {
        return this.conditions;
    }

    @JsonProperty(value="conditions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConditions(SAMLPayLoadDataAssertionConditions conditions) {
        this.conditions = conditions;
    }

    public SAMLPayLoadDataAssertion claims(Map<String, SAMLPayLoadDataAssertionClaimsValue> claims) {
        this.claims = claims;
        return this;
    }

    public SAMLPayLoadDataAssertion putclaimsItem(String key, SAMLPayLoadDataAssertionClaimsValue claimsItem) {
        if (this.claims == null) {
            this.claims = new HashMap<String, SAMLPayLoadDataAssertionClaimsValue>();
        }
        this.claims.put(key, claimsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Provides a JSON representation of the `<saml:AttributeStatement>` element contained in the generated SAML assertion. Contains any optional SAML attribute statements that you have defined for the app using the Admin Console's **SAML Settings**.")
    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, SAMLPayLoadDataAssertionClaimsValue> getClaims() {
        return this.claims;
    }

    @JsonProperty(value="claims")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaims(Map<String, SAMLPayLoadDataAssertionClaimsValue> claims) {
        this.claims = claims;
    }

    public SAMLPayLoadDataAssertion lifetime(SAMLPayLoadDataAssertionLifetime lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="lifetime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public SAMLPayLoadDataAssertionLifetime getLifetime() {
        return this.lifetime;
    }

    @JsonProperty(value="lifetime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLifetime(SAMLPayLoadDataAssertionLifetime lifetime) {
        this.lifetime = lifetime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMLPayLoadDataAssertion saMLPayLoadDataAssertion = (SAMLPayLoadDataAssertion)o;
        return Objects.equals(this.subject, saMLPayLoadDataAssertion.subject) && Objects.equals(this.authentication, saMLPayLoadDataAssertion.authentication) && Objects.equals(this.conditions, saMLPayLoadDataAssertion.conditions) && Objects.equals(this.claims, saMLPayLoadDataAssertion.claims) && Objects.equals(this.lifetime, saMLPayLoadDataAssertion.lifetime);
    }

    public int hashCode() {
        return Objects.hash(this.subject, this.authentication, this.conditions, this.claims, this.lifetime);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAMLPayLoadDataAssertion {\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    authentication: ").append(this.toIndentedString(this.authentication)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    claims: ").append(this.toIndentedString(this.claims)).append("\n");
        sb.append("    lifetime: ").append(this.toIndentedString(this.lifetime)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

