/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SAML 1.1 sign-on mode attributes")
@JsonPropertyOrder(value={"audienceOverride", "defaultRelayState", "recipientOverride", "ssoAcsUrlOverride"})
public class Saml11ApplicationSettingsSignOn
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUDIENCE_OVERRIDE = "audienceOverride";
    private String audienceOverride;
    public static final String JSON_PROPERTY_DEFAULT_RELAY_STATE = "defaultRelayState";
    private String defaultRelayState;
    public static final String JSON_PROPERTY_RECIPIENT_OVERRIDE = "recipientOverride";
    private String recipientOverride;
    public static final String JSON_PROPERTY_SSO_ACS_URL_OVERRIDE = "ssoAcsUrlOverride";
    private String ssoAcsUrlOverride;

    public Saml11ApplicationSettingsSignOn audienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The intended audience of the SAML assertion. This is usually the Entity ID of your application.")
    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAudienceOverride() {
        return this.audienceOverride;
    }

    @JsonProperty(value="audienceOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAudienceOverride(String audienceOverride) {
        this.audienceOverride = audienceOverride;
    }

    public Saml11ApplicationSettingsSignOn defaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of the resource to direct users after they successfully sign in to the SP using SAML. See the SP documentation to check if you need to specify a RelayState. In most instances, you can leave this field blank.")
    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDefaultRelayState() {
        return this.defaultRelayState;
    }

    @JsonProperty(value="defaultRelayState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDefaultRelayState(String defaultRelayState) {
        this.defaultRelayState = defaultRelayState;
    }

    public Saml11ApplicationSettingsSignOn recipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The location where the application can present the SAML assertion. This is usually the Single Sign-On (SSO) URL.")
    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRecipientOverride() {
        return this.recipientOverride;
    }

    @JsonProperty(value="recipientOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRecipientOverride(String recipientOverride) {
        this.recipientOverride = recipientOverride;
    }

    public Saml11ApplicationSettingsSignOn ssoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Assertion Consumer Services (ACS) URL value for the Service Provider (SP). This URL is always used for Identity Provider (IdP) initiated sign-on requests.")
    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSsoAcsUrlOverride() {
        return this.ssoAcsUrlOverride;
    }

    @JsonProperty(value="ssoAcsUrlOverride")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSsoAcsUrlOverride(String ssoAcsUrlOverride) {
        this.ssoAcsUrlOverride = ssoAcsUrlOverride;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Saml11ApplicationSettingsSignOn saml11ApplicationSettingsSignOn = (Saml11ApplicationSettingsSignOn)o;
        return Objects.equals(this.audienceOverride, saml11ApplicationSettingsSignOn.audienceOverride) && Objects.equals(this.defaultRelayState, saml11ApplicationSettingsSignOn.defaultRelayState) && Objects.equals(this.recipientOverride, saml11ApplicationSettingsSignOn.recipientOverride) && Objects.equals(this.ssoAcsUrlOverride, saml11ApplicationSettingsSignOn.ssoAcsUrlOverride);
    }

    public int hashCode() {
        return Objects.hash(this.audienceOverride, this.defaultRelayState, this.recipientOverride, this.ssoAcsUrlOverride);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Saml11ApplicationSettingsSignOn {\n");
        sb.append("    audienceOverride: ").append(this.toIndentedString(this.audienceOverride)).append("\n");
        sb.append("    defaultRelayState: ").append(this.toIndentedString(this.defaultRelayState)).append("\n");
        sb.append("    recipientOverride: ").append(this.toIndentedString(this.recipientOverride)).append("\n");
        sb.append("    ssoAcsUrlOverride: ").append(this.toIndentedString(this.ssoAcsUrlOverride)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

