/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The certificate that Okta uses to validate Single Logout (SLO) requests and responses")
@JsonPropertyOrder(value={"x5c"})
public class SamlSpCertificate
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_X5C = "x5c";
    private List<String> x5c = null;

    public SamlSpCertificate x5c(List<String> x5c) {
        this.x5c = x5c;
        return this;
    }

    public SamlSpCertificate addx5cItem(String x5cItem) {
        if (this.x5c == null) {
            this.x5c = new ArrayList<String>();
        }
        this.x5c.add(x5cItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list that contains exactly one x509 encoded certificate")
    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getX5c() {
        return this.x5c;
    }

    @JsonProperty(value="x5c")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setX5c(List<String> x5c) {
        this.x5c = x5c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SamlSpCertificate samlSpCertificate = (SamlSpCertificate)o;
        return Objects.equals(this.x5c, samlSpCertificate.x5c);
    }

    public int hashCode() {
        return Objects.hash(this.x5c);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SamlSpCertificate {\n");
        sb.append("    x5c: ").append(this.toIndentedString(this.x5c)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

