/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.SecurityEventTokenRequestJwtEvents;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="JSON Web Token body payload for a Security Event Token")
@JsonPropertyOrder(value={"aud", "events", "iat", "iss", "jti"})
public class SecurityEventTokenRequestJwtBody
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_AUD = "aud";
    private String aud;
    public static final String JSON_PROPERTY_EVENTS = "events";
    private SecurityEventTokenRequestJwtEvents events;
    public static final String JSON_PROPERTY_IAT = "iat";
    private Long iat;
    public static final String JSON_PROPERTY_ISS = "iss";
    private String iss;
    public static final String JSON_PROPERTY_JTI = "jti";
    private String jti;

    public SecurityEventTokenRequestJwtBody aud(String aud) {
        this.aud = aud;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://receiverexample.okta.com/", required=true, value="Audience")
    @JsonProperty(value="aud")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAud() {
        return this.aud;
    }

    @JsonProperty(value="aud")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAud(String aud) {
        this.aud = aud;
    }

    public SecurityEventTokenRequestJwtBody events(SecurityEventTokenRequestJwtEvents events) {
        this.events = events;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SecurityEventTokenRequestJwtEvents getEvents() {
        return this.events;
    }

    @JsonProperty(value="events")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEvents(SecurityEventTokenRequestJwtEvents events) {
        this.events = events;
    }

    public SecurityEventTokenRequestJwtBody iat(Long iat) {
        this.iat = iat;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1702448550", required=true, value="Token issue time (UNIX timestamp)")
    @JsonProperty(value="iat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Long getIat() {
        return this.iat;
    }

    @JsonProperty(value="iat")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIat(Long iat) {
        this.iat = iat;
    }

    public SecurityEventTokenRequestJwtBody iss(String iss) {
        this.iss = iss;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://transmitter.example.com", required=true, value="Token issuer")
    @JsonProperty(value="iss")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIss() {
        return this.iss;
    }

    @JsonProperty(value="iss")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIss(String iss) {
        this.iss = iss;
    }

    public SecurityEventTokenRequestJwtBody jti(String jti) {
        this.jti = jti;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="24c63fb56f ... a9fa24", required=true, value="Token ID")
    @JsonProperty(value="jti")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getJti() {
        return this.jti;
    }

    @JsonProperty(value="jti")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJti(String jti) {
        this.jti = jti;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventTokenRequestJwtBody securityEventTokenRequestJwtBody = (SecurityEventTokenRequestJwtBody)o;
        return Objects.equals(this.aud, securityEventTokenRequestJwtBody.aud) && Objects.equals(this.events, securityEventTokenRequestJwtBody.events) && Objects.equals(this.iat, securityEventTokenRequestJwtBody.iat) && Objects.equals(this.iss, securityEventTokenRequestJwtBody.iss) && Objects.equals(this.jti, securityEventTokenRequestJwtBody.jti);
    }

    public int hashCode() {
        return Objects.hash(this.aud, this.events, this.iat, this.iss, this.jti);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventTokenRequestJwtBody {\n");
        sb.append("    aud: ").append(this.toIndentedString(this.aud)).append("\n");
        sb.append("    events: ").append(this.toIndentedString(this.events)).append("\n");
        sb.append("    iat: ").append(this.toIndentedString(this.iat)).append("\n");
        sb.append("    iss: ").append(this.toIndentedString(this.iss)).append("\n");
        sb.append("    jti: ").append(this.toIndentedString(this.jti)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

