/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Security Events Provider with issuer and JWKS settings for signal ingestion")
@JsonPropertyOrder(value={"issuer", "jwks_url"})
public class SecurityEventsProviderSettingsNonSSFCompliant
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer;
    public static final String JSON_PROPERTY_JWKS_URL = "jwks_url";
    private String jwksUrl;

    public SecurityEventsProviderSettingsNonSSFCompliant issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="example.okta.com", required=true, value="Issuer URL")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public SecurityEventsProviderSettingsNonSSFCompliant jwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="https://example.okta.com/oauth2/v1/keys", required=true, value="The public URL where the JWKS public key is uploaded")
    @JsonProperty(value="jwks_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getJwksUrl() {
        return this.jwksUrl;
    }

    @JsonProperty(value="jwks_url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwksUrl(String jwksUrl) {
        this.jwksUrl = jwksUrl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SecurityEventsProviderSettingsNonSSFCompliant securityEventsProviderSettingsNonSSFCompliant = (SecurityEventsProviderSettingsNonSSFCompliant)o;
        return Objects.equals(this.issuer, securityEventsProviderSettingsNonSSFCompliant.issuer) && Objects.equals(this.jwksUrl, securityEventsProviderSettingsNonSSFCompliant.jwksUrl);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.jwksUrl);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SecurityEventsProviderSettingsNonSSFCompliant {\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUrl: ").append(this.toIndentedString(this.jwksUrl)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

