/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.TestInfoOidcTestConfiguration;
import com.okta.sdk.resource.model.TestInfoSamlTestConfiguration;
import com.okta.sdk.resource.model.TestInfoTestAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Integration Testing Information")
@JsonPropertyOrder(value={"escalationSupportContact", "oidcTestConfiguration", "samlTestConfiguration", "testAccount"})
public class TestInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ESCALATION_SUPPORT_CONTACT = "escalationSupportContact";
    private String escalationSupportContact;
    public static final String JSON_PROPERTY_OIDC_TEST_CONFIGURATION = "oidcTestConfiguration";
    private TestInfoOidcTestConfiguration oidcTestConfiguration;
    public static final String JSON_PROPERTY_SAML_TEST_CONFIGURATION = "samlTestConfiguration";
    private TestInfoSamlTestConfiguration samlTestConfiguration;
    public static final String JSON_PROPERTY_TEST_ACCOUNT = "testAccount";
    private TestInfoTestAccount testAccount;

    public TestInfo escalationSupportContact(String escalationSupportContact) {
        this.escalationSupportContact = escalationSupportContact;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="strawberry.support@example.com", required=true, value="An email for Okta to contact your company about your integration. This email isn't shared with customers.")
    @JsonProperty(value="escalationSupportContact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getEscalationSupportContact() {
        return this.escalationSupportContact;
    }

    @JsonProperty(value="escalationSupportContact")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEscalationSupportContact(String escalationSupportContact) {
        this.escalationSupportContact = escalationSupportContact;
    }

    public TestInfo oidcTestConfiguration(TestInfoOidcTestConfiguration oidcTestConfiguration) {
        this.oidcTestConfiguration = oidcTestConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="oidcTestConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TestInfoOidcTestConfiguration getOidcTestConfiguration() {
        return this.oidcTestConfiguration;
    }

    @JsonProperty(value="oidcTestConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOidcTestConfiguration(TestInfoOidcTestConfiguration oidcTestConfiguration) {
        this.oidcTestConfiguration = oidcTestConfiguration;
    }

    public TestInfo samlTestConfiguration(TestInfoSamlTestConfiguration samlTestConfiguration) {
        this.samlTestConfiguration = samlTestConfiguration;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="samlTestConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TestInfoSamlTestConfiguration getSamlTestConfiguration() {
        return this.samlTestConfiguration;
    }

    @JsonProperty(value="samlTestConfiguration")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSamlTestConfiguration(TestInfoSamlTestConfiguration samlTestConfiguration) {
        this.samlTestConfiguration = samlTestConfiguration;
    }

    public TestInfo testAccount(TestInfoTestAccount testAccount) {
        this.testAccount = testAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="testAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TestInfoTestAccount getTestAccount() {
        return this.testAccount;
    }

    @JsonProperty(value="testAccount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTestAccount(TestInfoTestAccount testAccount) {
        this.testAccount = testAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestInfo testInfo = (TestInfo)o;
        return Objects.equals(this.escalationSupportContact, testInfo.escalationSupportContact) && Objects.equals(this.oidcTestConfiguration, testInfo.oidcTestConfiguration) && Objects.equals(this.samlTestConfiguration, testInfo.samlTestConfiguration) && Objects.equals(this.testAccount, testInfo.testAccount);
    }

    public int hashCode() {
        return Objects.hash(this.escalationSupportContact, this.oidcTestConfiguration, this.samlTestConfiguration, this.testAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TestInfo {\n");
        sb.append("    escalationSupportContact: ").append(this.toIndentedString(this.escalationSupportContact)).append("\n");
        sb.append("    oidcTestConfiguration: ").append(this.toIndentedString(this.oidcTestConfiguration)).append("\n");
        sb.append("    samlTestConfiguration: ").append(this.toIndentedString(this.samlTestConfiguration)).append("\n");
        sb.append("    testAccount: ").append(this.toIndentedString(this.testAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

