/*
 * Decompiled with CFR 0.152.
 */
package com.okta.sdk.resource.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.okta.sdk.resource.model.TokenResponseTokenType;
import com.okta.sdk.resource.model.TokenType;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"access_token", "device_secret", "expires_in", "id_token", "issued_token_type", "refresh_token", "scope", "token_type"})
public class TokenResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_ACCESS_TOKEN = "access_token";
    private String accessToken;
    public static final String JSON_PROPERTY_DEVICE_SECRET = "device_secret";
    private String deviceSecret;
    public static final String JSON_PROPERTY_EXPIRES_IN = "expires_in";
    private Integer expiresIn;
    public static final String JSON_PROPERTY_ID_TOKEN = "id_token";
    private String idToken;
    public static final String JSON_PROPERTY_ISSUED_TOKEN_TYPE = "issued_token_type";
    private TokenType issuedTokenType;
    public static final String JSON_PROPERTY_REFRESH_TOKEN = "refresh_token";
    private String refreshToken;
    public static final String JSON_PROPERTY_SCOPE = "scope";
    private String scope;
    public static final String JSON_PROPERTY_TOKEN_TYPE = "token_type";
    private TokenResponseTokenType tokenType;

    public TokenResponse accessToken(String accessToken) {
        this.accessToken = accessToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An access token.")
    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccessToken() {
        return this.accessToken;
    }

    @JsonProperty(value="access_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public TokenResponse deviceSecret(String deviceSecret) {
        this.deviceSecret = deviceSecret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An opaque device secret. This is returned if the `device_sso` scope is granted.")
    @JsonProperty(value="device_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDeviceSecret() {
        return this.deviceSecret;
    }

    @JsonProperty(value="device_secret")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeviceSecret(String deviceSecret) {
        this.deviceSecret = deviceSecret;
    }

    public TokenResponse expiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The expiration time of the access token in seconds.")
    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    @JsonProperty(value="expires_in")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public TokenResponse idToken(String idToken) {
        this.idToken = idToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An ID token. This is returned if the `openid` scope is granted.")
    @JsonProperty(value="id_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getIdToken() {
        return this.idToken;
    }

    @JsonProperty(value="id_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIdToken(String idToken) {
        this.idToken = idToken;
    }

    public TokenResponse issuedTokenType(TokenType issuedTokenType) {
        this.issuedTokenType = issuedTokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="issued_token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenType getIssuedTokenType() {
        return this.issuedTokenType;
    }

    @JsonProperty(value="issued_token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuedTokenType(TokenType issuedTokenType) {
        this.issuedTokenType = issuedTokenType;
    }

    public TokenResponse refreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An opaque refresh token. This is returned if the `offline_access` scope is granted.")
    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @JsonProperty(value="refresh_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public TokenResponse scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The scopes contained in the access token.")
    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getScope() {
        return this.scope;
    }

    @JsonProperty(value="scope")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScope(String scope) {
        this.scope = scope;
    }

    public TokenResponse tokenType(TokenResponseTokenType tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TokenResponseTokenType getTokenType() {
        return this.tokenType;
    }

    @JsonProperty(value="token_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTokenType(TokenResponseTokenType tokenType) {
        this.tokenType = tokenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenResponse tokenResponse = (TokenResponse)o;
        return Objects.equals(this.accessToken, tokenResponse.accessToken) && Objects.equals(this.deviceSecret, tokenResponse.deviceSecret) && Objects.equals(this.expiresIn, tokenResponse.expiresIn) && Objects.equals(this.idToken, tokenResponse.idToken) && Objects.equals((Object)this.issuedTokenType, (Object)tokenResponse.issuedTokenType) && Objects.equals(this.refreshToken, tokenResponse.refreshToken) && Objects.equals(this.scope, tokenResponse.scope) && Objects.equals((Object)this.tokenType, (Object)tokenResponse.tokenType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accessToken, this.deviceSecret, this.expiresIn, this.idToken, this.issuedTokenType, this.refreshToken, this.scope, this.tokenType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TokenResponse {\n");
        sb.append("    accessToken: ").append(this.toIndentedString(this.accessToken)).append("\n");
        sb.append("    deviceSecret: ").append(this.toIndentedString(this.deviceSecret)).append("\n");
        sb.append("    expiresIn: ").append(this.toIndentedString(this.expiresIn)).append("\n");
        sb.append("    idToken: ").append(this.toIndentedString(this.idToken)).append("\n");
        sb.append("    issuedTokenType: ").append(this.toIndentedString((Object)this.issuedTokenType)).append("\n");
        sb.append("    refreshToken: ").append(this.toIndentedString(this.refreshToken)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("    tokenType: ").append(this.toIndentedString((Object)this.tokenType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

